#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "PidfStr.h"
#include "PidfAnsi.h"
#include "PidfRets.h"
#include "PidfDefs.h"
#include "libbase_udf.h"

void LoadSen (void *PIDF, ByTe_2 SenNo) 
{
   struct Pidf *P;
   struct PidfSensor *Ps;

   ByTe_2 Tu[100], *s1, Nu = 0;
   ByTe_1 PLine[150], Id[150];
   ByTe_1 *V;
   ByTe_1 *c1;

   ChkPidfMem (PIDF, SENSORS, SenNo + 1);
   
   P = (struct Pidf *) PIDF;                        /* PIDF interface struct */ 
   Ps = (struct PidfSensor *) P->Sensors + SenNo;   /* Sen structs here      */ 
   s1 = Tu;                                         /* tmp unit number array */
   
   Ps->Display = 1;                                 /* Display to 1          */
   Ps->ScanBlk = -1;                                /* Scan Block to -1      */
   Ps->BinBlk = -1;                                 /* Binning Defined to -1 */
   while (ProcLine(P->Fp, PLine) >= 0) {            /* read from SEN struct  */
      c1 = PLine;                                   /* ptr to PIDF line      */
      if (*c1 == '$' || *c1 == 0) {continue; }      /* comment or blank line */

      c1 = StripTo (c1, Id, ' ');                   /* strip out 1st entry   */

      if (Id[0] == '}')   { break; }                /* structure end?        */

      c1 = StripTo (c1, Id, ';');                   /* strip out 2nd entry   */
      V = BreakApart (Id);                          /* get ID and entry val  */ 
      switch (Id[0]) {                              /* sensor id switch      */
         case 'a':                                  /* START ANC SEN # CASE  */
            if (strcmp (Id, "anc_sensor") == 0)     /* anc sen num?          */
               sscanf (V, "%hd", &Ps->AncSen);      /* xfer value            */
         break;                                     /* STOP ANC SEN # CASE   */
         case 'b':                                  /* START SCAN BIN CASE   */
            if (strcmp (Id, "binning_index") == 0)  /* scan binning defined? */
               sscanf (V, "%hd", &Ps->BinBlk);      /* xfer value            */
         break;                                     /* STOP SCAN BIN CASE    */
         case 'c':                                  /* START COMPONENT CASE  */
            if (strcmp (Id, "component") == 0)      /* sen component label?  */
               Ps->Comp = Xfr(PIDF, V, ONEBYTE, 0); /* xfer value            */
         break;                                     /* STOP COMPONENT CASE   */
         case 'd':                                  /* START DSPLY FLG CASE  */
            if (strcmp (Id, "display_flag") == 0)   /* display flag?         */
               Ps->Display = V[0] - '0';            /* xfer value            */
         break;                                     /* STOP DSPLY FLG CASE   */
         case 'g':                                  /* START GROUP NUM CASE  */
            if (strcmp (Id, "group_num") == 0)      /* group num?            */
               sscanf (V, "%hd", &Ps->GroupNum);    /* xfer value            */
         break;                                     /* STOP GROUP NUM CASE   */
         case 'n':                                  /* START NAME/UNIT #     */
            if (strcmp (Id, "name") == 0)           /* main sensor label?    */
               Ps->Name = Xfr(PIDF, V, ONEBYTE, 0); /* xfer value            */
            else                                    /* probably # of units   */
               if (strcmp (Id, "num_units") == 0)   /* number of units?      */
                   sscanf (V, "%hd", &Ps->NUnits);  /* xfer value            */
         break;                                     /* STOP NAME/UNIT # CASE */
         case 'p':                                  /* START PA/PIDF # CASE  */
            if (strcmp (Id, "pitch_angle_flag") == 0) /* pitch angle?        */
               Ps->PitchAng = V[0];                   /* xfer value          */
            else                                        /* probably pidf #   */
               if (strcmp (Id, "pidf_sensor_num") == 0) /* pidf num?         */
                   sscanf (V, "%hd", &Ps->PidfNum);  /* xfer value           */
         break;                                      /* STOP PA/PIDF # CASE  */
         case 's':                                   /* START SRC/SCF/SBLK   */
            if (strcmp (Id, "scan_block_info") == 0) /* scan block info?     */
               sscanf (V, "%hd", &Ps->ScanBlk);      /* xfer value           */
            else                                     /* not scan block info  */
            {                                        /* BEGIN NOT SCAN BLK   */
               if (strcmp (Id, "scf_filename") == 0) /* scf filename?        */
                  Ps->ScfFile = Xfr(PIDF, V, ONEBYTE, 0);  /* xfer value     */
               else                                  /* must be source       */
                  if (strcmp (Id, "source") == 0)    /* source?              */
                     Ps->Src = V[0];                 /* xfer value           */
            }                                        /* END NOT SOURCE       */
         break;                                      /* STOP SRC/SCF/SBLK    */
         case 'u':                                   /* START UNIT # CASE    */
            if (strcmp (Id, "unit_number") == 0) {   /* unit num?            */
               sscanf (V, "%hd", s1++);             /* xfer value            */
               ++Nu;                                /* one more unit number  */
            }                                       /* END UNIT NUMBER       */
         break;                                      /* STOP UNIT # CASE     */
         case 'v':                                   /* START VIDF # CASE    */
            if (strcmp (Id, "vidf_sensor_num") == 0) /* vidf num?            */
               sscanf (V, "%hd", &Ps->VidfNum);      /* xfer value           */
         break;                                      /* STOP VIDF # CASE     */
      }                                              /* END SEN ID SWITCH    */
   }                                                 /* END READ SEN INFO    */

   /**************************************************************************/
   /*   DO ALL ARRAY TRANSFERS NOW                                           */
   /**************************************************************************/

   if (Nu > 0)                                          
      Ps->Units = (ByTe_2 *)Xfr(PIDF, (ByTe_1 *) Tu, TWOBYTE, Nu);
}
