#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "PidfStr.h"
#include "PidfAnsi.h"
#include "PidfRets.h"
#include "PidfDefs.h"
#include "libbase_udf.h"

void LoadPAng (void *PIDF) 
{
   struct Pidf *P;

   ByTe_2 Tu[100], *s1, Nu = 0;
   ByTe_1 PLine[150], Id[150];
   ByTe_1 *V;
   ByTe_1 *c1;

   P = (struct Pidf *) PIDF;                        /* PIDF interface struct */ 
   s1 = Tu;                                         /* tmp unit number array */
   
   P->PAngDef = 1;                                  /* defined pang struc    */
   while (ProcLine(P->Fp, PLine) >= 0)              /* read from PANG struct */
   {                                                /* BEGIN READ PANG INFO  */
      c1 = PLine;                                   /* ptr to PIDF line      */
      if (*c1 == '$' || *c1 == 0)                   /* comment or blnk line  */
         continue;                                  /* to next line          */

      c1 = StripTo (c1, Id, ' ');                   /* strip out 1st entry   */
      if (Id[0] == '}')                             /* structure end?        */
         break;                                     /* time to leave         */

      c1 = StripTo (c1, Id, ';');                   /* strip out 2nd entry   */
      V = BreakApart (Id);                          /* get ID and entry val  */ 
      switch (Id[0])                                /* sensor id switch      */
      {                                             /* BEGIN PANG ID SWITCH  */
         case 'n':                                  /* START 'n' CASE        */
            if (strcmp (Id, "name") == 0)           /* main mode label?      */
               P->Ap.LDesc = Xfr(PIDF, V, ONEBYTE, 0); /* xfer value         */
            else                                       /* maybe # of units   */
               if (strcmp (Id, "num_units") == 0)      /* number of units?   */
                   sscanf (V, "%hd", &P->Ap.NUnits);   /* xfer value         */
         break;                                     /* STOP 'n' CASE         */
         case 's':                                  /* START SDESC CASE      */
            if (strcmp (Id, "short_name") == 0)     /* short description?    */
               P->Ap.SDesc = Xfr(PIDF, V, ONEBYTE, 0);  /* xfer value        */
         break;                                     /* STOP SDESC CASE       */
         case 'u':                                  /* START UNIT # CASE     */
            if (strcmp (Id, "unit_number") == 0)    /* unit num?             */
            {                                       /* BEGIN UNIT NUMBER     */
               sscanf (V, "%hd", s1++);             /* xfer value            */
               ++Nu;                                /* one more unit number  */
            }                                       /* END UNIT NUMBER       */
         break;                                     /* STOP UNIT # CASE      */
      }                                             /* END PANG ID SWITCH    */
   }                                                /* END READ PANG INFO    */

   /**************************************************************************/
   /*   DO ALL ARRAY TRANSFERS NOW                                           */
   /**************************************************************************/

   if (Nu > 0)                                          
      P->Ap.Units = (ByTe_2 *)Xfr(PIDF, (ByTe_1 *) Tu, TWOBYTE, Nu);
}
