#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "PidfStr.h"
#include "PidfAnsi.h"
#include "PidfRets.h"
#include "PidfDefs.h"
#include "libbase_udf.h"

void LoadLatLong (void *PIDF, ByTe_2 N) 
{
   struct Pidf *P;
   struct PidfLatLong *Pl;

   ByTe_1 PLine[150], Id[150];
   ByTe_1 *V;
   ByTe_1 *c1, *c2;

   ChkPidfMem (PIDF, IMAGES, N + 1);
   
   P = (struct Pidf *) PIDF;                        /* PIDF interface struct */ 
   Pl = (struct PidfLatLong *) P->Pi.LatLong + N;   /* Lat/Long structs here */ 
   
   while (ProcLine(P->Fp, PLine) >= 0)              /* read from IMAGE struc */
   {                                                /* BEGIN READ IMAGE INFO */
      c1 = PLine;                                   /* ptr to PIDF line      */
      if (*c1 == '$' || *c1 == 0)                   /* comment or blnk line  */
         continue;                                  /* to next line          */

      c1 = StripTo (c1, Id, ' ');                   /* strip out 1st entry   */
      if (Id[0] == '}')                             /* structure end?        */
         break;                                     /* time to leave         */

      c1 = StripTo (c1, Id, ';');                   /* strip out 2nd entry   */
      V = BreakApart (Id);                          /* get ID and entry val  */ 

      if (strncmp (Id, "lat_", 4) == 0)             /* lat info?             */
      {                                             /* BEGIN LAT INFO        */
         c2 = Id + 4;                               /* skip lat_ text        */
         switch (*c2)                               /* lat id switch         */
         {                                          /* BEGIN LAT SWITCH      */
            case 'd':                               /* START DEFINITION CASE */
               if (strcmp (c2, "def") == 0)         /* lat location?         */
                  Pl->LatDef = Xfr(PIDF, V, ONEBYTE, 0); /* xfer value       */
            break;                                  /* STOP DEFINITION CASE  */
            case 'l':                               /* START LOCATION CASE   */
               if (strcmp (c2, "loc") == 0)         /* lat location?         */
                  Pl->LatLoc = V[0];                /* xfer value            */
            break;                                  /* STOP LOCATION CASE    */
            case 'n':                               /* START NUMBER CASE     */
               if (strcmp (c2, "num") == 0)         /* lat number?           */
                  sscanf (V, "%hd", &Pl->LatNum);   /* xfer value            */
            break;                                  /* STOP NUMBER CASE      */
            case 'u':                               /* START UNIT # CASE     */
               if (strcmp (c2, "unit") == 0)        /* lat unit?             */
                  sscanf (V, "%hd", &Pl->LatUnit);  /* xfer value            */
            break;                                  /* STOP UNIT # CASE      */
         }                                          /* END LAT SWITCH        */
      }                                             /* END LAT INFO          */
      else if (strncmp (Id, "long_", 5) == 0)       /* long info?            */
      {                                             /* BEGIN LONG INFO       */
         c2 = Id + 5;                               /* skip long_ text       */
         switch (*c2)                               /* long id switch        */
         {                                          /* BEGIN LONG SWITCH     */
            case 'd':                               /* START DEFINITION CASE */
               if (strcmp (c2, "def") == 0)         /* long location?        */
                  Pl->LongDef = Xfr(PIDF, V, ONEBYTE, 0); /* xfer value      */
            break;                                  /* STOP DEFINITION CASE  */
            case 'l':                               /* START LOCATION CASE   */
               if (strcmp (c2, "loc") == 0)         /* long location?        */
                  Pl->LongLoc = V[0];               /* xfer value            */
            break;                                  /* STOP LOCATION CASE    */
            case 'n':                               /* START NUMBER CASE     */
               if (strcmp (c2, "num") == 0)         /* long number?          */
                  sscanf (V, "%hd", &Pl->LongNum);  /* xfer value            */
            break;                                  /* STOP NUMBER CASE      */
            case 'u':                               /* START UNIT # CASE     */
               if (strcmp (c2, "unit") == 0)        /* long unit?            */
                  sscanf (V, "%hd", &Pl->LongUnit); /* xfer value            */
            break;                                  /* STOP UNIT # CASE      */
         }                                          /* END LONG SWITCH       */
      }                                             /* END LONG INFO         */
   }                                                /* END READ IMAGE INFO   */
}
