#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "PidfStr.h"
#include "PidfAnsi.h"
#include "PidfRets.h"
#include "PidfDefs.h"
#include "libbase_udf.h"

void LoadImage (void *PIDF) 
{
   struct Pidf *P;

   ByTe_2 N;
   ByTe_1 PLine[150], Id[150];
   ByTe_1 *V;
   ByTe_1 *c1;

   P = (struct Pidf *) PIDF;                        /* PIDF interface struct */
   P->ImageDef = 1;                                 /* image struct defined  */

   while (ProcLine(P->Fp, PLine) >= 0)              /* read from IMAGE struc */
   {                                                /* BEGIN READ IMAGE INFO */
      c1 = PLine;                                   /* ptr to PIDF line      */
      if (*c1 == '$' || *c1 == 0)                   /* comment or blnk line  */
         continue;                                  /* to next line          */

      c1 = StripTo (c1, Id, ' ');                   /* strip out 1st entry   */
      if (Id[0] == '}')                             /* structure end?        */
         break;                                     /* all done              */

      if (strcmp(Id, "struct") == 0)                /* begin a structure?    */
      {                                             /* BEGIN PROCESS STRUCT  */
         c1 = StripTo (c1, Id, ' ');                /* strip out next entry  */
         N = RmEndNum (Id);                         /* get struc type & Num  */
         if (strcmp(Id, "LatLong") == 0)            /* LatLong Info Right?   */
            LoadLatLong (PIDF, N);                  /* process lat/long      */
         continue;                                  /* next entry            */ 
      }                                             /* END PROCESS STRUCT    */

      c1 = StripTo (c1, Id, ';');                   /* strip out 2nd entry   */
      V = BreakApart (Id);                          /* get ID and entry val  */ 
      switch (Id[0])                                /* switch on id          */
      {                                             /* BEGIN IMAGE ID SWITCH */
         case 'b':                                  /* START BINNING CASE    */
            if (strcmp (Id, "bin_type") == 0)       /* image binning?        */
               P->Pi.BinType = V[0];                /* xfer value            */
         break;                                     /* STOP BINNING CASE     */
         case 'f':                                  /* START FORMAT CASE     */
            if (strcmp (Id, "format") == 0)         /* image format?         */
               P->Pi.Format = V[0];                 /* xfer value            */
         break;                                     /* STOP FORMAT CASE      */
         case 'n':                                  /* START NUM DEFS CASE   */
            if (strcmp (Id, "num_lat_longs") == 0)  /* num lat/long defs?    */
            {                                       /* BEGIN LAT LONG DEFS   */
               sscanf (V, "%hd", &P->Pi.NLatLong);    /* number definitions  */
               ChkPidfMem (PIDF, IMAGES, P->Pi.NLatLong); /* mem check       */
            }                                       /* END LAT LONG DEFS     */
         break;                                     /* STOP NUM DEFS CASE    */
         case 's':                                  /* START STORAGE CASE    */
            if (strcmp (Id, "storage") == 0)        /* image storage?        */
              P->Pi.Storage = Xfr(PIDF, V, ONEBYTE, 0); /* xfer value        */
         break;                                     /* STOP STORAGE CASE     */
         case 't':                                  /* START FORMAT CASE     */
            if (strcmp (Id, "type") == 0)           /* image type?           */
               P->Pi.Type = V[0];                   /* xfer value            */
         break;                                     /* STOP FORMAT CASE      */
      }                                             /* END IMAGE ID SWITCH   */
   }                                                /* END READ IMAGE INFO   */
}
