#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "PidfStr.h"
#include "PidfAnsi.h"
#include "PidfRets.h"
#include "PidfDefs.h"

void CreatePidfStruc (void **PidF) 
{
   struct Pidf *P;
   size_t bytes;

   bytes = sizeof (struct Pidf);                     /* structure size      */
   if ((*PidF = malloc (bytes)) == 0)                /* create it           */
      PidfErrs (PIDF_CREATE_ERROR, (ByTe_1 *)0);     /* gag if error        */

   P = (struct Pidf *)*PidF;                         /* point to structure  */
   P->Fp = 0;                                        /* no open             */
   P->MUnits = 0;                                    /* no units            */
   P->MSensors = 0;                                  /* no sensors          */
   P->MGroups = 0;                                   /* no groups           */
   P->MModes = 0;                                    /* no modes            */
   P->MScans = 0;                                    /* no scans            */
   P->MBins = 0;                                     /* no scans            */
   P->MAncil = 0;                                    /* no ancils           */
   P->MCMisc = 0;                                    /* no one bytes        */
   P->MSMisc = 0;                                    /* no two bytes        */
   P->Units = 0;                                     /* no units memory     */
   P->Sensors = 0;                                   /* no sensors memory   */
   P->Groups = 0;                                    /* no grp name memory  */
   P->Modes = 0;                                     /* no mode memory      */
   P->Ancil = 0;                                     /* no ancil memory     */
   P->Scans = 0;                                     /* no scan memory      */
   P->Bins = 0;                                      /* no bin memory       */
   P->CMisc = 0;                                     /* no one byte memory  */
   P->SMisc = 0;                                     /* no two byte memory  */
   P->DCMisc = 0;                                    /* no memory shift     */
   P->DSMisc = 0;                                    /* no memory shift     */
   P->NFGrp = 0;                                     /* init group name ptr */
   P->NFCMisc = 0;                                   /* init one byte ptr   */
   P->NFSMisc = 0;                                   /* init two byte ptr   */
   P->Pi.MLatLongs = 0;                              /* no lat/longs        */
   P->Pi.LatLong = 0;                                /* no lat/long mem     */
}
