#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "PidfStr.h"
#include "PidfAnsi.h"
#include "PidfRets.h"
#include "PidfDefs.h"

void ChkPidfMem (void *PIDF, ByTe_2 Part, ByTe_2 V) 
{
   struct Pidf *P;

   size_t B;
   ByTe_4 D;
   ByTe_4 I;
   ByTe_1 *Old, **Gn;

   P = (struct Pidf *) PIDF;                       /* PIDF interface struct  */ 

   switch (Part) {                                 /* switch on what to chk  */
      case ANCIL:                                  /* START ANCIL CASE       */
         D = V - P->MAncil;                        /* space needed           */
         if (D > 0) {                              /* need more memory?      */
            B = V * sizeof(struct PidfAnc);        /* this many bytes        */
            if ((P->Ancil = realloc (P->Ancil, B)) == 0)   /* get memory     */
               PidfErrs (PIDF_MEM_ERR, (ByTe_1 *)0);       /* out if err     */
            for (I = P->MAncil; I < V; ++I)        /* Anc struc init loop    */
               InitAncil (PIDF, I);                /* initialize new structs */
            P->MAncil = V;                         /* reset number groups    */
         }                                         /* END MEMEORY GET        */
      break;                                       /* STOP ANCIL CASE        */ 
      case BINS:                                   /* START BIN CASE         */
         D = V - P->MBins;                         /* space needed           */
         if (D > 0) {                              /* need more memory?      */
            B = V * sizeof(struct PidfBin);        /* this many bytes        */
            if ((P->Bins = realloc (P->Bins, B)) == 0)     /* get memory     */
               PidfErrs (PIDF_MEM_ERR, (ByTe_1 *)0);       /* out if err     */
            for (I = P->MBins; I < V; ++I)         /* Bin struc init loop    */
               InitBin (PIDF, I);                  /* initialize new structs */
            P->MBins = V;                          /* reset number groups    */
         }                                         /* END MEMEORY GET        */
      break;                                       /* STOP BIN CASE          */ 
      case GROUPS:                                 /* START GROUP CASE       */
         D = V - P->MGroups;                       /* space needed           */
         if (D > 0) {                              /* need more memory?      */
            if (P->MGroups == 0 && D < 10) V = 10; /* 10 minimum 1st malloc  */
            B = V * sizeof (ByTe_1 *);             /* this many bytes        */
            if ((P->Groups = realloc (P->Groups, B)) == 0) /* get memory     */
               PidfErrs (PIDF_MEM_ERR, (ByTe_1 *)0);       /* out if err     */
            Gn = (ByTe_1 **)P->Groups;             /* pointer to grp ptrs    */
            for (I = P->MGroups; I < V; ++I)       /* Group ptr init loop    */
               Gn[I] = 0;                          /* pointer nulled out     */
            P->MGroups = V;                        /* reset number groups    */
         }                                         /* END MEMEORY GET        */
      break;                                       /* STOP GROUP CASE        */ 
      case MODES:                                  /* START MODE CASE        */
         D = V - P->MModes;                        /* space needed           */
         if (D > 0) {                              /* need more memory?      */
            B = V * sizeof(struct PidfMode);       /* this many bytes        */
            if ((P->Modes = realloc (P->Modes, B)) == 0)      /* get memory  */
               PidfErrs (PIDF_MEM_ERR, (ByTe_1 *)0);          /* out if err  */
            for (I = P->MModes; I < V; ++I)        /* mode struc init loop   */
               InitMode (PIDF, I);                 /* initialize new structs */
            P->MModes = V;                         /* reset number groups    */
         }                                         /* END MEMEORY GET        */
      break;                                       /* STOP MODE CASE         */ 
      case SCANS:                                  /* START SCAN CASE        */
         D = V - P->MScans;                        /* space needed           */
         if (D > 0) {                              /* need more memory?      */
            B = V * sizeof(struct PidfScan);       /* this many bytes        */
            if ((P->Scans = realloc (P->Scans, B)) == 0)      /* get memory  */
               PidfErrs (PIDF_MEM_ERR, (ByTe_1 *)0);          /* out if err  */
            for (I = P->MScans; I < V; ++I)        /* Scan struc init loop   */
               InitScan (PIDF, I);                 /* initialize new structs */
            P->MScans = V;                         /* reset number groups    */
         }                                         /* END MEMEORY GET        */
      break;                                       /* STOP SCAN CASE         */ 
      case SENSORS:                                /* START SENSOR CASE      */
         D = V - P->MSensors;                      /* space needed           */
         if (D > 0) {                              /* need more memory?      */
            B = V * sizeof(struct PidfSensor);     /* this many bytes        */
            if ((P->Sensors = realloc (P->Sensors, B)) == 0)  /* get memory  */
               PidfErrs (PIDF_MEM_ERR, (ByTe_1 *)0);          /* out if err  */
            for (I = P->MSensors; I < V; ++I)      /* Sensor struc init loop */
               InitSensor (PIDF, I);               /* initialize new structs */
            P->MSensors = V;                       /* reset number groups    */
         }                                         /* END MEMEORY GET        */
      break;                                       /* STOP SENSOR CASE       */ 
      case UNITS:                                  /* START UNITS CASE       */
         D = V - P->MUnits;                        /* space needed           */
         if (D > 0) {                              /* need more memory?      */
            B = V * sizeof(struct PidfUnit);       /* this many bytes        */
            if ((P->Units = realloc (P->Units, B)) == 0)   /* get memory     */
               PidfErrs (PIDF_MEM_ERR, (ByTe_1 *)0);       /* out if err     */
            for (I = P->MUnits; I < V; ++I)        /* Unit struc init loop   */
               InitUnit (PIDF, I);                 /* initialize new structs */
            P->MUnits = V;                         /* reset number groups    */
         }                                         /* END MEMEORY GET        */
      break;                                       /* STOP UNITS CASE        */ 
      case IMAGES:                                 /* START IMAGES CASE      */
         D = V - P->Pi.MLatLongs;                  /* space needed           */
         if (D > 0) {                              /* need more memory?      */
            B = V * sizeof(struct PidfLatLong);    /* this many bytes        */
            if ((P->Pi.LatLong = realloc (P->Pi.LatLong, B)) == 0) 
               PidfErrs (PIDF_MEM_ERR, (ByTe_1 *)0);         
            for (I = P->Pi.MLatLongs; I < V; ++I)  /* Unit struc init loop   */
               InitLatLong (PIDF, I);              /* initialize new structs */
            P->Pi.MLatLongs = V;                   /* reset number groups    */
         }                                         /* END MEMEORY GET        */
      break;                                       /* STOP IMAGES CASE       */
      case ONEBYTE:                                /* START ONEBYTE CASE     */
         D = V + P->NFCMisc - P->MCMisc;           /* space needed           */
         if (D > 0) {                              /* need more memory?      */
	    B = D;
            Old = (ByTe_1 *)P->CMisc;              /* old memory start       */
            if (P->CMisc == 0) {                   /* no memory at all       */
               if (B < 1024)  B = 1024;            /* min 1024 1st malloc    */
            } else {                               /* not first malloc       */
               if (B < 512)  B = P->MCMisc + 512;  /* min inc of 512 bytes   */
            }

            if ((P->CMisc = realloc (P->CMisc, B)) == 0)   /* get memory     */
               PidfErrs (PIDF_MEM_ERR, (ByTe_1 *)0);       /* out if err     */
            P->MCMisc = B;                         /* reset bytes malloced   */

            if (Old != 0) {                        /* memory updated         */
               P->DCMisc = (ByTe_1 *)P->CMisc - Old;  /* memory shift        */ 
               if (P->DCMisc != 0)                    /* was memory shifted? */
                  PtrUpDate (PIDF, ONEBYTE);          /* compensate          */
            }                                      /* END MEM SHIFT STUFF    */ 
         }                                         /* END MEMEORY GET        */
      break;                                       /* STOP ONEBYTE CASE      */ 
      case TWOBYTE:                                /* START TWOBYTE CASE     */
         D = V + P->NFSMisc - P->MSMisc;           /* space needed           */
         if (D > 0) {                              /* need more memory?      */
	    B = D;
            Old = (ByTe_1 *)P->SMisc;              /* old memory start       */
            if (P->SMisc == 0) {                   /* no memory at all       */
               if (B < 256)  B = 256;              /* min 256 1st malloc     */
            } else {                               /* END FIRST MEM GET      */
               if (B < 128)  B = P->MSMisc + 128;  /* min inc of 128 slots   */
            }

            B *= sizeof (ByTe_2);                  /* number of bytes needed */
            if ((P->SMisc = realloc (P->SMisc, B)) == 0)   /* get memory     */
               PidfErrs (PIDF_MEM_ERR, (ByTe_1 *)0);       /* out if err     */
            P->MSMisc = B / sizeof (ByTe_2);       /* reset number groups    */
            if (Old != 0) {                        /* memory updated         */
               P->DSMisc = (ByTe_1 *)P->SMisc - Old;  /* memory shift        */ 
               if (P->DSMisc != 0)                    /* was memory shifted? */
                  PtrUpDate (PIDF, TWOBYTE);          /* compensate          */
            }                                      /* END MEM SHIFT STUFF    */ 
         }                                         /* END MEMEORY GET        */
      break;                                       /* STOP TWOBYTE CASE      */ 
   }                                               /* END SIZE CHK SWITCH    */
}
