#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "PidfStr.h"
#include "PidfAnsi.h"
#include "PidfRets.h"
#include "PidfDefs.h"
#include "libbase_udf.h"

ByTe_2 ReadPidf (u_ByTe_4 Key, void *PIDF) 
{
   struct Pidf *P;

   ByTe_2 N;

   ByTe_1 PLine[150], Id[150];
   ByTe_1 *c1;

   if (OpenPidf (Key, PIDF) == 0)                  /* PIDF opened            */
      return (1);                                  /* yes - don't process    */

   P = (struct Pidf *) PIDF;                       /* PIDF interface struct  */ 
   while (ProcLine(P->Fp, PLine) >= 0)             /* read from PIDF         */
   {                                               /* BEGIN PIDF FIND START  */
      c1 = PLine;                                  /* ptr to PIDF line       */

      if (*c1 == '$' || *c1 == 0) { continue; }    /* comment or blnk line   */
      
      c1 = StripTo (c1, Id, ' ');                  /* strip out 1st entry    */
      if ( *c1 == 0 ) { continue; }

      if (strcmp(Id, "struct") == 0)               /* begin a structure?     */
      {                                            /* BEGIN PROCESS STRUCT   */
         c1 = StripTo (c1, Id, ' ');               /* strip out next entry   */
         N = RmEndNum (Id);                        /* get struc type & Num   */
         switch (Id[0])                            /* structure switch       */
         {                                         /* BEGIN SWITCH ON STRUCT */
            case 'B':                              /* START BIN CASE         */
              if (strcmp(Id, "Bin") == 0)          /* begin an bin struct?   */
                  LoadBin (PIDF, N) ;              /* load bin definition    */
            break;                                 /* STOP BIN CASE          */
            case 'C':                              /* START ANCIL CASE       */
              if (strcmp(Id, "CalSet") == 0)       /* begin an ancil struct? */
                  LoadAnc (PIDF, N) ;              /* load ancil definition  */
            break;                                 /* STOP ANCIL CASE        */
            case 'D':                              /* START QUALITY CASE     */
              if (strcmp(Id, "DataQual") == 0)     /* begin a qual struct?   */
                  LoadQual (PIDF);                 /* load qual definition   */
            break;                                 /* STOP QUALITY CASE      */
            case 'I':                              /* START IMAGE CASE       */
              if (strcmp(Id, "Image") == 0)        /* begin a qual struct?   */
                  LoadImage (PIDF);                /* load qual definition   */
            break;                                 /* STOP IMAGE CASE        */
            case 'M':                              /* START MODE CASE        */
              if (strcmp(Id, "Mode") == 0)         /* begin a mode struct?   */
                  LoadMode (PIDF, N);              /* load mode definition   */
            break;                                 /* STOP MODE CASE         */
            case 'P':                              /* START PITCH ANG CASE   */
              if (strcmp(Id, "PitchAngle") == 0)   /* begin a Pang struct?   */
                  LoadPAng (PIDF);                 /* load Pang definition    */
            break;                                 /* STOP PITCH ANG CASE    */
            case 'S':                              /* START SENSOR/SCAN CASE */
              if (strcmp(Id, "Sensor") == 0)       /* begin a sensor struct? */
                  LoadSen (PIDF, N);               /* load sensor definition */
              else                                 /* must be SCAN or SANG   */
              {                                    /* BEGIN SCAN or SPIN     */
                 if (strcmp(Id, "SpinAngle") == 0) /* begin spin ang struct? */
                      LoadSAng (PIDF);             /* load spin angle def    */
                 else                              /* only scan blk left     */
                    if (strcmp(Id, "Scan") == 0)   /* begin scanblk struct?  */
                        LoadScan (PIDF, N);        /* load scanblk def       */
              }                                    /* BEGIN SCAN or SPIN     */
            break;                                 /* STOP SENSOR/SCAN CASE  */
            case 'U':                              /* START UNITS CASE       */
              if (strcmp(Id, "Unit") == 0)         /* begin a unit struct?   */
                  LoadUnit (PIDF, N);              /* load unit definition   */
            break;                                 /* STOP UNITS CASE        */
         }                                         /* BEGIN SWITCH ON STRUCT */
      }                                            /* END PROCESS STRUCT     */
      else                                         /* fixed field data       */
      {                                            /* BEG FIXED FIELD DATA   */
         c1 = StripTo (c1, Id, ';');               /* strip out entry        */
         c1 = BreakApart (Id);
         switch (Id[0]) {                          /* switch on first char   */
            case 'n':                              /* START CASE 's'         */
               if (strncmp(Id, "num_", 4) == 0)    /* begin a size of?       */
                  PidfSizes (PIDF, Id, c1);        /* get value & check mem  */
               else                                /* one of fixed fields    */
                  LoadFixed (PIDF, Id, c1);        /* grab field             */
            break;                                 /* STOP  CASE 's'         */ 
            default:                               /* START FIXED FIELD CASE */
               LoadFixed (PIDF, Id, c1);           /* grab field             */
            break;                                 /* STOP FIXED FIELD CASE  */
         }                                         /* END PIDF ITEM SWITCH   */
      }                                            /* BEG FIXED FIELD DATA   */
   }

   return (1);
}
