#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "PidfStr.h"
#include "PidfAnsi.h"
#include "PidfRets.h"

ByTe_2 ProcOper (ByTe_1 *Op) 
{
   ByTe_2 OpCode;

   switch (*Op)                                      /* operation switch     */
   {                                                 /* BEGIN OPER SWITCH    */
      case '=':                                      /* START EQUAL CASE     */
         OpCode = 0;                                 /* set equal            */
      break;                                         /* END EQUAL CASE       */
      case '+':                                      /* START ADD CASE       */
         OpCode = 1;                                 /* set plus             */
      break;                                         /* END ADD CASE         */
      case '-':                                      /* START SUB CASE       */
         if (*(Op+1) >= '0' && *(Op+1) <= '9')       /* is negative opcode?  */
            sscanf (Op, "%hd", &OpCode);             /* process as such      */
         else                                        /* just a minus sign    */
            OpCode = 2;                              /* set minus            */
      break;                                         /* END SUB CASE         */
      case '*':                                      /* START MULT CASE      */
         OpCode = 3;                                 /* set times            */
      break;                                         /* END MULT CASE        */
      case '/':                                      /* START DIV CASE       */
         OpCode = 4;                                 /* set divide           */
      break;                                         /* END DIV CASE         */
      case '&':                                      /* START AND CASE       */
         OpCode = 5;                                 /* set logical and      */
      break;                                         /* END AND CASE         */
      case '|':                                      /* START OR CASE        */
         OpCode = 6;                                 /* set logical and      */
      break;                                         /* END OR CASE          */
      case '>':                                      /* START SHIFT-R CASE   */
         OpCode = 7;                                 /* set bit shift right  */
      break;                                         /* END SHIFT RIGHT CASE */
      case '<':                                      /* START SHIFT-L CASE   */
         OpCode = 8;                                 /* set bit shift right  */
      break;                                         /* END SHIFT LEFT CASE  */
      case '^':                                      /* START POWER CASE     */
         OpCode = 9;                                 /* set bit shift right  */
      break;                                         /* END POWER CASE       */
      case '%':                                      /* START MOD CASE       */
         OpCode = -1;                                /* set bit shift right  */
      break;                                         /* END MOD CASE         */
      default:                                       /* START NUMERICAL CASE */
         sscanf (Op, "%hd", &OpCode);                /* get op value         */
      break;                                         /* END NUMERICAL CASE   */
   }                                                 /* END OPER SWITCH      */

   return (OpCode);
}
