#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "PidfAnsi.h"
#include "PidfStr.h"
#include "PidfDefs.h"

void PrHeader (void *PIDF) 
{
   struct Pidf *P;
   
   ByTe_4 L, M, H, R;
   ByTe_1 *c1, **G, Bl[50];

   P = (struct Pidf *)PIDF;

   L = strlen (P->Path);
   M = 48 - L;
   H = M/2;
   R = M % 2;

   printf ("\n     **************************************************\n");

   printf ("     *");
   for (M = 0, c1 = Bl; M < H; ++M)
      *c1++ = ' ';
   *c1 = 0;
   printf ("%s%s%s", Bl, P->Path, Bl);
   if (R == 1)
      printf (" *\n");
   else
      printf ("*\n");

   printf ("     **************************************************\n\n");

   printf ("\n     **************************************************\n");
   printf ("     *                PREFACE BLOCK                   *\n");
   printf ("     **************************************************\n\n");

   printf ("Version:        %.1f\n", P->Pf.Version);
   printf ("Institute:      %s\n", P->Pf.Institute);
   printf ("Project:        %s\n", P->Pf.Project);
   printf ("Mission:        %s\n", P->Pf.Mission);
   printf ("Experiment:     %s\n", P->Pf.Exper);
   printf ("Instrument:     %s\n", P->Pf.Inst);
   printf ("Virutal:        %s\n", P->Pf.Vinst);

   printf ("\n     **************************************************\n");
   printf ("     *           GENERAL INFORMATION BLOCK            *\n");
   printf ("     **************************************************\n\n");

   printf ("Plot Formats:   0x%02hx (%hd)\n", P->Pf.PlotTypes, P->Pf.PlotTypes);
   printf ("Data Present:   0x%02hx (%hd)\n", P->Pf.DataTypes, P->Pf.DataTypes);
   printf ("Dependencies:   0x%02hx (%hd)\n", P->Pf.Depends, P->Pf.Depends);
   printf ("Data Blocking:  %hd\n", P->Pf.Blocking);
   printf ("Phi Min/Max:    %9.3e / %9.3e\n", P->Pf.PhiMin, P->Pf.PhiMax);
   printf ("Theta Min/Max:  %9.3e / %9.3e\n", P->Pf.ThetaMin, P->Pf.ThetaMax);
   printf ("Scan Min/Max:   %9.3e / %9.3e\n", P->Pf.ScanMin, P->Pf.ScanMax);
   printf ("Mass Min/Max:   %9.3e / %9.3e\n", P->Pf.MassMin, P->Pf.MassMax);
   printf ("Charge Min/Max: %9.3e / %9.3e\n", P->Pf.ChargeMin, P->Pf.ChargeMax);
   printf ("Energy Min/Max: %9.3e / %9.3e\n", P->Pf.EnergyMin, P->Pf.EnergyMax);
   printf ("Freq Min/Max:   %9.3e / %9.3e\n", P->Pf.FreqMin, P->Pf.FreqMax);
   printf ("Phi Cyclic:     %c\n",P->Pf.Cyclic);
   printf ("Sensor Type:    %c\n",P->Pf.SenType);

   printf ("\n     **************************************************\n");
   printf ("     *    GROUP BLOCK   %2d TOTAL GROUP DEFINITIONS    *\n", 
                       P->Ps.NGroups);
   printf ("     **************************************************\n\n");

   G = (ByTe_1 **)P->Groups;
   for (L = 0; L < P->Ps.NGroups; ++L)
      printf ("Group Name[%2d]: %s\n", L, G[L]);
   printf ("\n");
}
