#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "PidfAnsi.h"
#include "PidfStr.h"
#include "PidfDefs.h"

void PrAngsQual (void *PIDF, ByTe_2 What) 
{
   struct Pidf *P;
   
   ByTe_2 *s1, *sEnD, Nu, *Un; 
   ByTe_1 *Ld, *Sd, Lab[80], Def;

   P = (struct Pidf *)PIDF;

   Lab[0] = 0;
   switch (What)
   {
      case PANG:
         sprintf (Lab, "*               PITCH ANGLE BLOCK         "); 
         Def = P->PAngDef;
         Ld = P->Ap.LDesc;
         Sd = P->Ap.SDesc;
         Nu = P->Ap.NUnits;
         Un = P->Ap.Units;
      break;
      case SANG:
         sprintf (Lab, "*                SPIN ANGLE BLOCK         "); 
         Def = P->SAngDef;
         Ld = P->As.LDesc;
         Sd = P->As.SDesc;
         Nu = P->As.NUnits;
         Un = P->As.Units;
      break;
      case QUALITY:
         sprintf (Lab, "*                  QUALITY BLOCK          "); 
         Def = P->QualDef;
         Ld = P->Pq.LDesc;
         Sd = P->Pq.SDesc;
         Nu = P->Pq.NUnits;
         Un = P->Pq.Units;
      break;
   }

   printf ("\n     **************************************************\n");
   printf ("     %s       *\n", Lab); 
   if (Def == 0)
      printf ("     *                    UNDEFINED                   *\n"); 
   printf ("     **************************************************\n\n");

   if (Def == 0)
      return;

   if (Ld != 0)
      printf ("Name:         %s\n", Ld);
   if (Sd != 0)
      printf ("Abbr:         %s\n", Sd);

   printf ("# Of Units:   %hd\n", Nu);

   printf ("Units:        ");
   s1 = Un;
   sEnD = s1 + Nu;
   printf ("%hd", *s1++);
   for ( ; s1 < sEnD; )
      printf (" | %hd", *s1++);
   printf ("\n");
}
