#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "PidfAnsi.h"
#include "PidfStr.h"
#include "PidfDefs.h"

void PrAncils (void *PIDF) 
{
   struct Pidf *P;
   struct PidfAnc *Pa;
   
   ByTe_4 I;   
   ByTe_2 *s1, *sEnD;   

   P = (struct Pidf *)PIDF;

   printf ("\n     **************************************************\n");
   printf ("     *     ANCIL BLOCK   %2d TOTAL BIN DEFINITIONS     *\n", 
                       P->Ps.NAncils);
   printf ("     **************************************************\n\n");

   Pa = (struct PidfAnc *)P->Ancil;
   for (I = 0; I < P->Ps.NAncils; ++I, ++Pa)
   {                                        
       printf ("**************\n");
       printf ("* ANC SET %2d *\n", I);
       printf ("**************\n");

       if (Pa->LDesc != 0)
           printf ("              Name:       %s\n", Pa->LDesc);
       if (Pa->SDesc != 0)
           printf ("              Abbr:       %s\n", Pa->SDesc);
       printf ("              PidfNum:    %d\n", Pa->PidfNum);
       printf ("              VidfNum:    %d\n", Pa->VidfNum);
       printf ("              # Of Units: %d\n", Pa->NUnits);
       printf ("              Units:      ");
       if (Pa->NUnits > 0)
       {
          s1 = Pa->Units;
          sEnD = s1 + Pa->NUnits;
          printf ("%hd", *s1++);
          for ( ; s1 < sEnD; )
             printf (" | %hd", *s1++);
       }
       printf ("\n");
       printf ("              Sensor Dep: %c\n", Pa->Modify);
       printf ("              # Of Sens:  %d\n", Pa->NSen);
       if (Pa->NSen > 0)
       {
          printf ("              Sensors:    ");
          s1 = Pa->Sen;
          sEnD = s1 + Pa->NSen;
          printf ("%hd", *s1++);
          for ( ; s1 < sEnD; )
             printf (" | %hd", *s1++);
          printf ("\n");
       }
   }            
}
