#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "PidfAnsi.h"
#include "PidfRets.h"

void PidfErrs (ByTe_2 ErrCode, ByTe_1 *Add)
{
   switch (ErrCode)
   {
      case PIDF_MISSING_ENV:
        fprintf (stderr, "PIDF: Environment %s not set\n", Add);
      break;
      case PIDF_NO_DBCFG:
        fprintf (stderr, "PIDF: Can't open DB.cfg file\n");
      break;
      case PIDF_NO_PIDF:
        fprintf (stderr, "PIDF: Can't open PIDF file %s\n", Add);
      break;
      case PIDF_BAD_PROJECT:
        fprintf (stderr, "PIDF: Bad PROJECT Name\n");
      break;
      case PIDF_BAD_MISSION:
        fprintf (stderr, "PIDF: Bad MISSION Name\n");
      break;
      case PIDF_BAD_EXPER:
        fprintf (stderr, "PIDF: Bad EXPERIMENT Name\n");
      break;
      case PIDF_BAD_INST:
        fprintf (stderr, "PIDF: Bad INSTRUMENT Name\n");
      break;
      case PIDF_BAD_VINST:
        fprintf (stderr, "PIDF: Bad VIRTUAL INSTRUMENT Name\n");
      break;
      case PIDF_BAD_GMALLOC:
        fprintf (stderr, "PIDF: Bad GROUP NAME MALLOC\n");
      break;
   }

   exit (-1);
}
