#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "OpSySInD.h"
#include "PidfStr.h"
#include "PidfAnsi.h"
#include "PidfRets.h"
#include "PidfDefs.h"
#include "libbase_udf.h"

ByTe_2 OpenPidf (u_ByTe_4 KeY, void *PIDF) 
{
   FILE *Fo;

   struct Pidf *P;

   ByTe_2 Level = 0, keys[5], RV, Pstat = 0;
   ByTe_1 Name[150];

   ByTe_1 *EnV;
   ByTe_1 *Slash = PathSep;
   ByTe_1 DB[150], DBLine[150], DBEntry[50], PMEIV[200];
   ByTe_1 TmP[40];
   ByTe_1 *c1, *c2, *Id;
   ByTe_1 Done = 0;

   P = (struct Pidf *) PIDF;                        /* PIDF interface struct */
   if (P->Fp != 0)                                  /* Previous Open         */
   {                                                /* BEGIN PREVIOUS OPEN   */
      if (P->Key == KeY) {                          /* right one opened?     */
         return(0);                                 /* we're done            */
      } else { fclose (P->Fp); }                    /* close current file    */
   }                                                /* END PREVIOUS OPEN     */
   
   InitPidf (PIDF);                                 /* initialize PIDF struc */
   Name[0] = 0;                                     /* null the path         */
   key_to_fields (KeY, keys);                       /* get PMEIV keys        */

   if ((RV = KeysToStr (keys, PMEIV)) != ALL_OKAY)  /* key strings           */
      PidfErrs (RV, (ByTe_1 *)0);                   /* report error          */ 

   if ((EnV = getenv("UDF_HOME")) == 0)             /* IDF Base Directory    */
      PidfErrs (PIDF_MISSING_ENV, "UDF_HOME");      /* error if no env set   */ 

   sprintf (DB, "%s%sconfig%sDB.cfg", EnV, Slash, Slash);  /* DB.cfg path    */

   if ((Fo = fopen (DB, "r")) == NULL)              /* open DB.cfg           */
      PidfErrs (PIDF_NO_DBCFG, (ByTe_1 *)0);        /* error if can't open   */

   while (ProcLine(Fo, DBLine) >= 0 && !Done)       /* read from DB.cfg      */
   {                                                /* BEGIN READ DB.cfg     */
      c1 = DBLine;                                  /* ptr to DB.cfg line    */

      if (*c1 == '#' || *c1 == 0)                   /* comment or blnk line  */
         continue;                                  /* to next line          */

      c1 = StripTo (c1, DBEntry, ' ');              /* strip out 1st entry   */
      if (strcmp(DBEntry, "PidfPath.VALUE") == 0)   /* base PIDF entry?      */
         c1 = StripTo (c1, Name, ' ');              /* strip out next entry  */
      else                                          /* specific PIDF path?   */
      {                                             /* BEGIN GET SPEC PIDF   */
         c2 = StripTo (DBEntry, DB, '.');           /* strip out PMEIV       */
         c2 = StripTo (c2, TmP, ' ');               /* strip out type        */
         Id = PMEIV;                                /* PMEIV strings         */
         if (strcmp(TmP, "PidfPath.VALUE") == 0)    /* spec PIDF entry?      */
         {                                          /* BEGIN PIDF ENTRY      */
            Level = 0;                              /* level counter         */
            c2 = DB;                                /* ptr to PMEIV          */
            c2 = StripTo (DB, TmP, ':');            /* get Project level     */

            while (strcmp(TmP, Id) == 0)            /* loop through levels   */
            {                                       /* BEGIN WALK THROUGH    */
               ++Level;                             /* incr level cntr       */
               Id += 40;                            /* next PMEIV string Id  */
               c2 = StripTo (c2, TmP, ':');         /* get  PMEIV level      */
               if (TmP[0] == 0)                     /* end of entrys?        */
               {                                    /* BEGIN GOT ENTRY       */
                  Done = 1;                         /* we are done           */
                  c1 = StripTo (c1, Name, ' ');     /* get next entry        */
               }                                    /* END GOT ENTRY         */
            }                                       /* END WALK THROUGH      */
         }                                          /* END PIDF ENTRY        */
      }                                             /* END GET SPEC PIDF     */
   }                                                /* END READ DB.cfg       */

   RmDelims (Name, DQ);                             /* remove " from entry   */
   if (Name[0] == '$')                              /* environment var?      */
      SubEnvVar (Name);                             /* plug it in            */
   FormPidfPath (Name, PMEIV, Level);               /* make full path        */
   P->Path = Xfr(PIDF, Name, ONEBYTE, 0);           /* save path             */

   fclose (Fo);

   if ((P->Fp = fopen (P->Path, "r")) == NULL) {      /* open PIDF file      */
      if (getenv("UDFPROMOTE") != NULL) {
         sscanf (getenv("UDFPROMOTE"), "%hd", &Pstat);
         if (Pstat < 0 ) { Pstat = -Pstat; }
      }
      PromoteFile("SEARCHP", KeY, 1990, 1, 0, 1990, 2, 0, Pstat); 
      if ((P->Fp = fopen (P->Path, "r")) == NULL) {
         PidfErrs (PIDF_NO_PIDF, P->Path); 
      }
   }
   P->Key = KeY;                                   /* current PIDF key       */

   return (1);
}
