#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "PidfStr.h"
#include "PidfAnsi.h"
#include "PidfRets.h"
#include "PidfDefs.h"
#include "libbase_udf.h"

void LoadUnit (void *PIDF, ByTe_2 UnitNo) 
{
   struct Pidf *P;
   struct PidfUnit *Pu;

   ByTe_2 To[500], *s1, N = 0, Tval;
   ByTe_1 PLine[150], Id[150], Tt[500];
   ByTe_1 *V;
   ByTe_1 *c1, *c2;

   ChkPidfMem (PIDF, UNITS, UnitNo + 1);
   
   P = (struct Pidf *) PIDF;                        /* PIDF interface struct */ 
   Pu = (struct PidfUnit *) P->Units + UnitNo;      /* Unit structs here     */ 

   c2 = Tt;                                         /* tmp tables array      */
   s1 = To;                                         /* tmp ops array         */

   while (ProcLine(P->Fp, PLine) >= 0)              /* read from UNIT struc  */
   {                                                /* BEGIN READ UNIT INFO  */
      c1 = PLine;                                   /* ptr to PIDF line      */
      if (*c1 == '$' || *c1 == 0)                   /* comment or blnk line  */
         continue;                                  /* to next line          */

      c1 = StripTo (c1, Id, ' ');                   /* strip out 1st entry   */
      if (Id[0] == '}')                             /* structure end?        */
         break;                                     /* all done              */

      c1 = StripTo (c1, Id, ';');                   /* strip out 2nd entry   */
      V = BreakApart (Id);                          /* get ID and entry val  */ 
      switch (Id[0])                                /* switch on id          */
      {                                             /* BEGIN UNIT ID SWITCH  */
         case 'i':                                  /* START ID CASE         */
            if (strcmp (Id, "id") == 0)             /* unit id?              */
               sscanf (V, "%d", &Pu->Id);           /* xfer value            */
         break;                                     /* STOP ID CASE          */
         case 'l':                                  /* START LONG DESC CASE  */
            if (strcmp (Id, "long_description") == 0)  /* unit long desc?    */
               Pu->LDesc = Xfr(PIDF, V, ONEBYTE, 0);   /* xfer value         */
            else                                    /* not long label        */
            {                                       /* BEGIN NOT LONG LAB    */
               if (strcmp (Id, "local_id") == 0)    /* unit local id?        */
                  sscanf (V, "%d", &Pu->LocalId);   /* xfer value            */
            }                                       /* END NOT LONG LAB      */
         break;                                     /* STOP LONG DESC CASE   */
         case 'm':                                  /* START MIN/MAX CASE    */
            if (strcmp (Id, "min") == 0)            /* unit min value?       */
               sscanf (V, "%f", &Pu->Min);          /* xfer value            */
            else                                    /* probably max          */
               if (strcmp (Id, "max") == 0)         /* unit max value?       */
                  sscanf (V, "%f", &Pu->Max);       /* xfer value            */
         break;                                     /* STOP MIN/MAX CASE     */
         case 'n':                                  /* START # TABLES CASE   */
            if (strcmp (Id, "num_tables") == 0)     /* unit min value?       */
               sscanf (V, "%hd", &Pu->NTbls);       /* xfer value            */
         break;                                     /* STOP # TABLES CASE    */
         case 's':                                  /* START SHORT DESC CASE */
            if (strcmp (Id, "short_description") == 0) /* unit short desc?   */
               Pu->SDesc = Xfr(PIDF, V, ONEBYTE, 0);   /* xfer value         */
         break;                                     /* STOP SHORT DESC CASE  */
         case 't':                                  /* START TBL/OPER CASE   */
            if (strcmp (Id, "tbl_app_flag") == 0)   /* table number?         */
            {                                       /* BEGIN GET TABLE NUMS  */
               sscanf (V, "%hd", &Tval);            /* get value             */
               *c2++ = Tval;                        /* xfer value            */
               ++N;                                 /* increment counter     */
            }                                       /* END GET TABLE NUMS    */
            else                                    /* probably label        */
               if (strcmp (Id, "tbl_app_oper") == 0) /* unit label?          */
                  *s1++ = ProcOper(V);              /* xfer oper value       */
         break;                                     /* STOP TBL/OPER CASE    */
         case 'u':                                  /* START SCA/LAB CASE    */
            if (strcmp (Id, "unit_scaling") == 0)   /* unit scale?           */
               sscanf (V, "%hd", &Pu->Sca);         /* xfer value            */
            else                                    /* probably label        */
               if (strcmp (Id, "unit_label") == 0)  /* unit label?           */
                  Pu->ULab = Xfr(PIDF, V, ONEBYTE, 0);  /* xfer value        */
         break;                                     /* STOP SCA/LAB CASE     */
      }                                             /* END UNIT ID SWITCH    */
   }                                                /* END READ UNIT INFO    */

   /**************************************************************************/
   /*   DO ALL ARRAY TRANSFERS NOW                                           */
   /**************************************************************************/

   if (N > 0)                                          
   {
      Pu->Ops = (ByTe_2 *)Xfr(PIDF, (ByTe_1 *) To, TWOBYTE, N);
      Pu->Tbls = Xfr(PIDF, Tt, ONEBYTE, N);
   }
}
