#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "PidfStr.h"
#include "PidfAnsi.h"
#include "PidfRets.h"
#include "PidfDefs.h"
#include "libbase_udf.h"

void LoadScan (void *PIDF, ByTe_2 ScanNo) 
{
   struct Pidf *P;
   struct PidfScan *Pc;

   ByTe_2 Tu[100], Tv[100], *s1, *s2, N = -1, Bn;
   ByTe_1 Tt[100], Tl[100];
   ByTe_1 PLine[150], Id[150], Ts[100];
   ByTe_1 *V;
   ByTe_1 *c1, *c2, *c3;

   ChkPidfMem (PIDF, SCANS, ScanNo + 1);
   
   P = (struct Pidf *) PIDF;                        /* PIDF interface struct */ 
   Pc = (struct PidfScan *) P->Scans + ScanNo;      /* ScanBlk structs here  */ 

   c2 = Tt;                                         /* tmp tables array      */
   s1 = Tu;                                         /* tmp ops array         */

   while (ProcLine(P->Fp, PLine) >= 0)              /* read from SCAN struc  */
   {                                                /* BEGIN READ SCAN INFO  */
      c1 = PLine;                                   /* ptr to PIDF line      */
      if (*c1 == '$' || *c1 == 0)                   /* comment or blnk line  */
         continue;                                  /* to next line          */

      c1 = StripTo (c1, Id, ' ');                   /* strip out 1st entry   */
      if (Id[0] == '}')                             /* structure end?        */
         break;                                     /* all done              */

      if (strcmp(Id, "struct") == 0)                /* begin a structure?    */
      {                                             /* BEGIN PROCESS STRUCT  */
         c1 = StripTo (c1, Id, ' ');                /* strip out next entry  */
         Bn = RmEndNum (Id);                        /* get struc type & Num  */
         if (strcmp(Id, "ScanUnit") == 0)           /* Scan Block Right?     */
         {                                          /* BEGIN SCAN BLK STRUCT */
            s1 = Tu + Bn;                           /* units goes here       */
            s2 = Tv + Bn;                           /* var units goes here   */
            c2 = Ts + Bn;                           /* scaling goes here     */
            c3 = Tl + Bn;                           /* scan fmt goes here    */
            LoadSBlk (PIDF, ScanNo, c2, s1, c3, s2); /* proces scan blk      */
            N = (Bn > N) ? Bn : N;                  /* keep maximum pos      */
         }                                          /* END SCAN BLK STRUCT   */
         continue;                                  /* next entry            */ 
      }                                             /* END PROCESS STRUCT    */

      c1 = StripTo (c1, Id, ';');                   /* strip out 2nd entry   */
      V = BreakApart (Id);                          /* get ID and entry val  */ 
      switch (Id[0])                                /* switch on id          */
      {                                             /* BEGIN SCAN ID SWITCH  */
         case 'n':                                  /* START No. UNITS CASE  */
            if (strcmp (Id, "num_units") == 0)      /* number of units?      */
               sscanf (V, "%hd", &Pc->NUnits);      /* xfer value            */
         break;                                     /* STOP No. UNITS CASE   */
      }                                             /* END SCAN ID SWITCH    */
   }                                                /* END READ SCAN INFO    */

   /**************************************************************************/
   /*   DO ALL ARRAY TRANSFERS NOW                                           */
   /**************************************************************************/

   ++N;
   if (N > 0)                                          
   {
      Pc->Units = (ByTe_2 *)Xfr(PIDF, (ByTe_1 *) Tu, TWOBYTE, N);
      Pc->Step = Xfr(PIDF, Ts, ONEBYTE, N);
      Pc->VUnits = (ByTe_2 *)Xfr(PIDF, (ByTe_1 *) Tv, TWOBYTE, N);
      Pc->Loc = Xfr(PIDF, Tl, ONEBYTE, N);
   }
}
