#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "PidfStr.h"
#include "PidfAnsi.h"
#include "PidfRets.h"
#include "PidfDefs.h"
#include "libbase_udf.h"

void LoadSBlk (void *PIDF, ByTe_2 ScanNo, ByTe_1 *Sca, ByTe_2 *Unit,
                 ByTe_1 *Loc, ByTe_2 *VUnit)
         
{
   struct Pidf *P;
   struct PidfScan *Pc;

   ByTe_1 PLine[150], Id[150];
   ByTe_1 *V;
   ByTe_1 *c1;
   
   P = (struct Pidf *) PIDF;                        /* PIDF interface struct */ 
   Pc = (struct PidfScan *) P->Scans + ScanNo;      /* ScanBlk structs here  */ 
   *Loc = '-';                                      /* init loc to empty     */
   *VUnit = -1;                                     /* init vunit to illegal */
   *Unit = -1;                                      /* init unit to illegal  */
   *Sca = '-';                                      /* init sca to empty     */

   while (ProcLine(P->Fp, PLine) >= 0)              /* read from UNIT struc  */
   {                                                /* BEGIN READ UNIT INFO  */
      c1 = PLine;                                   /* ptr to PIDF line      */
      if (*c1 == '$' || *c1 == 0)                   /* comment or blnk line  */
         continue;                                  /* to next line          */

      c1 = StripTo (c1, Id, ' ');                   /* strip out 1st entry   */
      if (Id[0] == '}')                             /* structure end?        */
         break;                                     /* all done              */

      c1 = StripTo (c1, Id, ';');                   /* strip out 2nd entry   */
      V = BreakApart (Id);                          /* get ID and entry val  */ 
      switch (Id[0])                                /* switch on id          */
      {                                             /* BEGIN UNIT ID SWITCH  */
         case 'b':                                  /* START SCALING CASE    */
            if (strcmp (Id, "bin_location") == 0)   /* scan definition?      */
               *Loc = V[0];                         /* xfer value            */
         break;                                     /* STOP ID CASE          */
         case 's':                                  /* START SCALING CASE    */
            if (strcmp (Id, "spacing") == 0)        /* unit id?              */
               *Sca = V[0];                         /* xfer value            */
         break;                                     /* STOP ID CASE          */
         case 'u':                                  /* START UNITS CASE      */
            if (strcmp (Id, "units_index") == 0)    /* unit number?          */
               sscanf (V, "%hd", Unit);             /* xfer value            */
         break;                                     /* STOP UNITS CASE       */
         case 'v':                                  /* START VAR UNITS CASE  */
            if (strcmp (Id, "var_units") == 0)      /* var unit?             */
               sscanf (V, "%hd", VUnit);            /* xfer value            */
         break;                                     /* STOP VAR UNITS CASE   */
      }                                             /* END UNIT ID SWITCH    */
   }                                                /* END READ UNIT INFO    */
}
