#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "PidfStr.h"
#include "PidfAnsi.h"
#include "PidfRets.h"
#include "PidfDefs.h"
#include "libbase_udf.h"

void LoadFixed (void *PIDF, ByTe_1 *Id, ByTe_1* V) 
{
   struct Pidf *P;

   ByTe_1 **Gn;
   
   P = (struct Pidf *) PIDF;                        /* PIDF interface struct */ 
   switch (Id[0])                                   /* switch on PIDF id     */
   {                                                /* BEGIN PIDF ID SWITCH  */
      case 'b':                                     /* START 'b' CASE        */
         if (strcmp (Id, "blocking") == 0)          /* inst blocking?        */
               sscanf (V, "%hd", &P->Pf.Blocking);  /* xfer value            */
      break;                                        /* STOP 'b' CASE         */
      case 'c':                                     /* START 'c' CASE        */
         if (strcmp (Id, "cyclic") == 0)            /* Phi is cyclic?        */
               P->Pf.Cyclic = V[0];                 /* xfer value            */
         else                                       /* must be chage stuff   */
         {                                          /* BEGIN GET CHRG INFO   */
            if (strcmp (Id, "charge_min") == 0)     /* min charge value?     */
               sscanf (V, "%f", &P->Pf.ChargeMin);  /* xfer value            */
            else                                    /* must be max           */
               if (strcmp (Id, "charge_max") == 0)  /* max charge value?     */
                  sscanf (V, "%f", &P->Pf.ChargeMax);  /* xfer value         */
         }                                          /* END GET CHRG INFO     */
      break;                                        /* STOP 'c' CASE         */
      case 'd':                                     /* START DATA TYPE CASE  */
         if (strcmp (Id, "data_type_mask") == 0)    /* display flag?         */
         {                                          /* BEGIN DATA TYPE       */
            if (IsHex(V) == 1)                      /* hex value?            */
               sscanf (V, "%hx", &P->Pf.DataTypes); /* xfer value            */
            else                                    /* decimal               */
               sscanf (V, "%hd", &P->Pf.DataTypes); /* xfer value            */
         }                                          /* END DATA TYPE         */
      break;                                        /* STOP DATA TYPE CASE   */
      case 'e':                                     /* START EXPERIMENT CASE */
         if (strcmp (Id, "experiment") == 0)        /* IDFS experiment?      */
           P->Pf.Exper = Xfr(PIDF, V, ONEBYTE, 0);  /* xfer value            */
         else                                       /* must be energy stuff  */
         {                                          /* BEGIN GET ENERGY INFO */
            if (strcmp (Id, "energy_min") == 0)     /* min energy value?     */
               sscanf (V, "%f", &P->Pf.EnergyMin);  /* xfer value            */
            else                                    /* must be max           */
               if (strcmp (Id, "energy_max") == 0)  /* max energy value?     */
                  sscanf (V, "%f", &P->Pf.EnergyMax);  /* xfer value         */
         }                                          /* END GET ENERGY INFO   */
      break;                                        /* STOP EXPERIMENT CASE  */
      case 'f':                                     /* START FREQ CASE       */
         if (strcmp (Id, "freq_min") == 0)          /* min freq value?       */
            sscanf (V, "%f", &P->Pf.FreqMin);       /* xfer value            */
         else                                       /* must be max           */
            if (strcmp (Id, "freq_max") == 0)       /* max freq value?       */
               sscanf (V, "%f", &P->Pf.FreqMax);    /* xfer value            */
      break;                                        /* STOP FREQ CASE        */
      case 'g':                                     /* START GROUP NM CASE   */
         if (strcmp (Id, "group_name") == 0)        /* group name?           */
         {                                          /* BEGIN GET GROUP NAME  */
            ChkPidfMem (PIDF, GROUPS, P->NFGrp + 1); /* memory check         */
            Gn = (ByTe_1 **)P->Groups + P->NFGrp;   /* put name here         */
            *Gn = Xfr(PIDF, V, ONEBYTE, 0);         /* xfer value            */
            ++P->NFGrp;                             /* one more group name   */
         }                                          /* END GET GROUP NAME    */
      break;                                        /* STOP GROUP NAME CASE  */
      case 'i':                                     /* START I's CASE        */
         if (strcmp (Id, "instrument_dep") == 0)    /* inst dependencys?     */
         {                                          /* BEGIN INST DEPENDS    */
            if (IsHex(V) == 1)                      /* hex value?            */
               sscanf (V, "%hx", &P->Pf.Depends);   /* xfer value            */
            else                                    /* decimal               */
               sscanf (V, "%hd", &P->Pf.Depends);   /* xfer value            */
         }                                          /* END INST DEPENDS      */
         else                                       /* check rest            */
         {                                          /* BEGIN MORE I's        */
            if (strcmp (Id, "institution") == 0)    /* institution info?     */
               P->Pf.Institute = Xfr(PIDF, V, ONEBYTE, 0); /* xfer val       */
            else                                    /* instrument then       */
               if (strcmp (Id, "instrument") == 0)  /* instrument acronym?   */
                   P->Pf.Inst = Xfr(PIDF, V, ONEBYTE, 0); /* xfer value      */
         }                                          /* END MORE I's          */
      break;                                        /* STOP I's CASE         */
      case 'm':                                     /* START MISSION CASE    */
         if (strcmp (Id, "mission") == 0)           /* IDFS mission?         */
            P->Pf.Mission = Xfr(PIDF, V, ONEBYTE, 0);  /* xfer value         */
         else                                       /* must be chage stuff   */
         {                                          /* BEGIN GET MASS INFO   */
            if (strcmp (Id, "mass_min") == 0)       /* min mass value?       */
               sscanf (V, "%f", &P->Pf.MassMin);    /* xfer value            */
            else                                    /* must be max           */
               if (strcmp (Id, "mass_max") == 0)    /* max mass value?       */
                  sscanf (V, "%f", &P->Pf.MassMax); /* xfer value            */
         }                                          /* END GET MASS INFO     */
      break;                                        /* STOP MISSION CASE     */
      case 'p':                                     /* START P's CASE        */
         if (strcmp (Id, "plot_avail_flag") == 0)   /* plot availibility     */
         {                                          /* BEGIN PLOT AVAIL      */
            if (IsHex(V) == 1)                      /* hex value?            */
               sscanf (V, "%hx", &P->Pf.PlotTypes); /* xfer value            */
            else                                    /* decimal               */
               sscanf (V, "%hd", &P->Pf.PlotTypes); /* xfer value            */
         }                                          /* END PLOT AVAIL        */
         else                                       /* one of the others     */
         {                                          /* BEGIN OTHERS          */
            if (strcmp (Id, "project") == 0)        /* IDFS project?         */
               P->Pf.Project = Xfr(PIDF, V, ONEBYTE, 0);  /* xfer value      */
            else                                    /* one of the phi's      */
            {                                       /* BEGIN GET PHI INFO    */
               if (strcmp (Id, "phi_min") == 0)     /* min phi value?        */
                  sscanf (V, "%f", &P->Pf.PhiMin);  /* xfer value            */
               else                                 /* must be max           */
                  if (strcmp (Id, "phi_max") == 0)    /* max phi value?      */
                     sscanf (V, "%f", &P->Pf.PhiMax); /* xfer value          */
            }                                       /* END GET PHI INFO      */
         }                                          /* END OTHERS            */
      break;                                        /* STOP P's CASE         */
      case 's':                                     /* START SCANS CASE      */
         if (strcmp (Id, "scan_min") == 0)          /* min scan value?       */
            sscanf (V, "%f", &P->Pf.ScanMin);       /* xfer value            */
         else                                       /* must be max           */
            if (strcmp (Id, "scan_max") == 0)       /* max scan value?       */
               sscanf (V, "%f", &P->Pf.ScanMax);    /* xfer value            */
            else                                    /* must be sensor type   */
               if (strcmp (Id, "sen_type") == 0)    /* sensor type value?    */
                  P->Pf.SenType = V[0];             /* xfer value            */
      break;                                        /* STOP SCANS CASE       */
      case 't':                                     /* START THETA CASE      */
         if (strcmp (Id, "theta_min") == 0)         /* min theta value?      */
            sscanf (V, "%f", &P->Pf.ThetaMin);      /* xfer value            */
         else                                       /* must be max           */
            if (strcmp (Id, "theta_max") == 0)      /* max theta value?      */
               sscanf (V, "%f", &P->Pf.ThetaMax);   /* xfer value            */
      break;                                        /* END THETA CASE        */
      case 'v':                                     /* START VINST/VER CASE  */
         if (strcmp (Id, "version") == 0)           /* pief version num?     */
            sscanf (V, "%f", &P->Pf.Version);       /* xfer value            */
         else                                       /* must be virtual       */
            if (strcmp (Id, "vinst") == 0)          /* virtual inst?         */
               P->Pf.Vinst = Xfr(PIDF, V, ONEBYTE, 0);  /* xfer value        */
      break;                                        /* STOP VINST/VER CASE   */
   }                                                /* BEGIN PIDF ID SWITCH  */
}
