#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "PidfStr.h"
#include "PidfAnsi.h"
#include "PidfRets.h"
#include "PidfDefs.h"
#include "libbase_udf.h"

void LoadBin (void *PIDF, ByTe_2 BinNo) 
{
   struct Pidf *P;
   struct PidfBin *Pb;

   ByTe_1 PLine[150], Id[150];
   ByTe_1 *Val;
   ByTe_1 *c1;

   ChkPidfMem (PIDF, BINS, BinNo + 1);
   
   P = (struct Pidf *) PIDF;                        /* PIDF interface struct */ 
   Pb = (struct PidfBin *) P->Bins + BinNo;         /* Binning structs here  */ 

   while (ProcLine(P->Fp, PLine) >= 0)              /* read from BIN struct  */
   {                                                /* BEGIN READ BIN INFO   */
      c1 = PLine;                                   /* ptr to PIDF line      */
      if (*c1 == '$' || *c1 == 0)                   /* comment or blnk line  */
         continue;                                  /* to next line          */

      c1 = StripTo (c1, Id, ' ');                   /* strip out 1st entry   */
      if (Id[0] == '}')                             /* structure end?        */
         break;                                     /* all done              */

      c1 = StripTo (c1, Id, ';');                   /* strip out 2nd entry   */
      Val = BreakApart (Id);                        /* get ID and entry val  */ 
      switch (Id[0])                                /* switch on id          */
      {                                             /* BEGIN BIN ID SWITCH   */
         case 'b':                                  /* START SCALING CASE    */
            if (strcmp (Id, "bin_scaling") == 0)    /* bin scaling?          */
               sscanf (Val, "%hd", &Pb->Sca);       /* xfer value            */
         break;                                     /* STOP SCALING CASE     */
         case 'm':                                  /* START 'm' CASE        */
            if (strcmp (Id, "method") == 0)         /* bin method?           */
               sscanf (Val, "%hd", &Pb->Method);    /* xfer value            */
            else                                    /* must be min/max       */
            {                                       /* BEGIN GET MIN/MAX     */
               if (strcmp (Id, "min") == 0)         /* bin min value?        */
                  sscanf (Val, "%f", &Pb->Min);     /* xfer value            */
               else                                 /* probably max          */
                  if (strcmp (Id, "max") == 0)      /* bin max value?        */
                     sscanf (Val, "%f", &Pb->Max);  /* xfer value            */
            }                                       /* END GET MIN/MAX       */
         break;                                     /* STOP 'm CASE          */
         case 'n':                                  /* START # BINS CASE     */
            if (strcmp (Id, "num_bins") == 0)       /* bin number?           */
               sscanf (Val, "%d", &Pb->NBins);      /* xfer value            */
         break;                                     /* STOP # BINS CASE      */
      }                                             /* END BIN ID SWITCH     */
   }                                                /* END READ BIN INFO     */
}
