#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "PidfStr.h"
#include "PidfAnsi.h"
#include "PidfRets.h"
#include "PidfDefs.h"
#include "libbase_udf.h"

void LoadAnc (void *PIDF, ByTe_2 AncNo) 
{
   struct Pidf *P;
   struct PidfAnc *Pa;

   ByTe_2 Tu[100], *s1, Nu = 0;
   ByTe_2 Ts[100], *s2, Ns = 0;
   ByTe_1 PLine[150], Id[150];
   ByTe_1 *V;
   ByTe_1 *c1;

   ChkPidfMem (PIDF, ANCIL, AncNo + 1);
   
   P = (struct Pidf *) PIDF;                        /* PIDF interface struct */ 
   Pa = (struct PidfAnc *) P->Ancil + AncNo;        /* Ancil structs here    */ 
   s1 = Tu;                                         /* tmp unit nums array   */
   s2 = Ts;                                         /* tmp sen depend array  */
   
   while (ProcLine(P->Fp, PLine) >= 0)              /* read from ANC struct  */
   {                                                /* BEGIN READ ANC INFO   */
      c1 = PLine;                                   /* ptr to PIDF line      */
      if (*c1 == '$' || *c1 == 0)                   /* comment or blnk line  */
         continue;                                  /* to next line          */

      c1 = StripTo (c1, Id, ' ');                   /* strip out 1st entry   */
      if (Id[0] == '}')                             /* structure end?        */
         break;                                     /* time to leave         */

      c1 = StripTo (c1, Id, ';');                   /* strip out 2nd entry   */
      V = BreakApart (Id);                          /* get ID and entry val  */ 

      switch (Id[0])                                /* sensor id switch      */
      {                                             /* BEGIN ANC ID SWITCH   */
         case 'c':                                  /* START 'c' CASE        */
            if (strcmp (Id, "cal_based_on_sensor") == 0)  /* cal sensors     */
            {                                       /* BEGIN SENSOR NUMBER   */
               sscanf (V, "%hd", s2++);             /* xfer value            */
               ++Ns;                                /* one more sen number   */
            }                                       /* END SENSOR NUMBER     */
            else                                          /* must be modify  */
               if (strcmp (Id, "cal_modify_flag") == 0)   /* cal modify      */
                  Pa->Modify = V[0];                      /* xfer value      */
         break;                                     /* STOP 'c' CASE         */
         case 'n':                                  /* START 'n' CASE        */
            if (strcmp (Id, "number_cal_sensors") == 0) /* number anc sen?   */
               sscanf (V, "%hd", &Pa->NSen);            /* xfer value        */
            else                                        /* name or # units   */
            {                                       /* BEGIN CHK MORE        */
               if (strcmp (Id, "num_units") == 0)   /* number of units?      */
                  sscanf (V, "%hd", &Pa->NUnits);   /* xfer value            */
               else                                 /* probably # of units   */
                  if (strcmp (Id, "name") == 0)        /* main anc label ?   */
                     Pa->LDesc = Xfr(PIDF, V, ONEBYTE, 0);  /* xfer value    */
            }                                       /* BEGIN CHK MORE        */
         break;                                     /* STOP 'n' CASE         */
         case 'p':                                  /* START PIDF # CASE     */
            if (strcmp (Id, "pidf_cal_num") == 0)   /* pidf num?             */
                sscanf (V, "%hd", &Pa->PidfNum);    /* xfer value            */
         break;                                     /* STOP PIDF # CASE      */
         case 's':                                  /* START SDESC CASE      */
            if (strcmp (Id, "short_name") == 0)     /* short description?    */
               Pa->SDesc = Xfr(PIDF, V, ONEBYTE, 0);  /* xfer value          */
         break;                                     /* STOP SDESC CASE       */
         case 'u':                                  /* START UNIT # CASE     */
            if (strcmp (Id, "unit_number") == 0)    /* unit num?             */
            {                                       /* BEGIN UNIT NUMBER     */
               sscanf (V, "%hd", s1++);             /* xfer value            */
               ++Nu;                                /* one more unit number  */
            }                                       /* END UNIT NUMBER       */
         break;                                     /* STOP UNIT # CASE      */
         case 'v':                                  /* START VIDF # CASE     */
            if (strcmp (Id, "vidf_cal_num") == 0)   /* vidf num?             */
               sscanf (V, "%hd", &Pa->VidfNum);     /* xfer value            */
         break;                                     /* STOP VIDF # CASE      */
      }                                             /* END ANC ID SWITCH     */
   }                                                /* END READ ANC INFO     */

   /**************************************************************************/
   /*   DO ALL ARRAY TRANSFERS NOW                                           */
   /**************************************************************************/

   if (Nu > 0)                                          
      Pa->Units = (ByTe_2 *)Xfr(PIDF, (ByTe_1 *) Tu, TWOBYTE, Nu);
   if (Ns > 0)                                          
      Pa->Sen = (ByTe_2 *)Xfr(PIDF, (ByTe_1 *) Ts, TWOBYTE, Ns);
}
