#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "PidfAnsi.h"
#include "PidfStr.h"
#include "PidfDefs.h"

void InitSensor (void *PIDF, ByTe_4 N) 
{
   struct Pidf *P;
   struct PidfSensor *Px;
   
   P = (struct Pidf *)PIDF;

   Px = (struct PidfSensor *)P->Sensors + N;         /* ptr to sensor struct */
   Px->Name = 0;                                     /* no name              */
   Px->Comp = 0;                                     /* no component         */
   Px->Src = 'N';                                    /* no source            */
   Px->ScfFile = 0;                                  /* no scf file          */
   Px->PitchAng = 'N';                               /* no pitch angle       */
   Px->PidfNum = -1;                                 /* illegal PIDF number  */
   Px->VidfNum = -1;                                 /* illegal VIDF number  */
   Px->AncSen = -1;                                  /* universal Anc Senosr */
   Px->GroupNum = -1;                                /* illegal group number */
   Px->ScanBlk = -1;                                 /* no scan block        */
   Px->NUnits = 0;                                   /* no defined units     */
   Px->Units = 0;                                    /* no unit info         */
}
