#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "PidfStr.h"
#include "PidfAnsi.h"
#include "PidfRets.h"
#include "PidfDefs.h"

void InitPidf (void *PIDF) 
{
   struct Pidf *P;
  
   ByTe_4 I;

   P = (struct Pidf *)PIDF;                      /* point to structure      */

   P->Fp = 0;                                    /* current pidf file desc  */
   P->Path = 0;                                  /* path to IDFS            */
   P->NFGrp = 0;                                 /* group name counter      */
   P->NFCMisc = 0;                               /* next free 1 byte misc   */
   P->NFSMisc = 0;                               /* next free 2 byte misc   */
   P->DCMisc = 0;                                /* 1 byte mem shift        */
   P->DSMisc = 0;                                /* 2 byte mem shift        */
   P->ImageDef = 0;                              /* image struct unfilled   */
   P->QualDef = 0;                               /* quality struct unfilled */
   P->PAngDef = 0;                               /* p ang struct unfilled   */
   P->SAngDef = 0;                               /* s ang struct unfilled   */

   P->Ps.NGroups = 0;                            /* groups defined          */
   P->Ps.NUnits = 0;                             /* units defined           */
   P->Ps.NSensors = 0;                           /* sensors defined         */
   P->Ps.NScans = 0;                             /* scanblks defined        */
   P->Ps.NBins = 0;                              /* bins defined            */
   P->Ps.NAncils = 0;                            /* ancillary sets defined  */
   P->Ps.NModes = 0;                             /* modes defined           */

   P->Pf.Version = 0.0;                          /* pidf version            */
   P->Pf.Institute = 0;                          /* institute label         */
   P->Pf.Project = 0;                            /* IDFS Project acronym    */
   P->Pf.Mission = 0;                            /* IDFS Mission acronym    */
   P->Pf.Exper = 0;                              /* IDFS Exper acronym      */
   P->Pf.Inst = 0;                               /* IDFS Inst acronym       */
   P->Pf.Vinst = 0;                              /* IDFS VInst acronym      */
   P->Pf.PlotTypes = 1;                          /* plot types              */
   P->Pf.DataTypes = 0;                          /* data types              */
   P->Pf.Blocking = 0;                           /* no blocking             */
   P->Pf.Depends = 0;                            /* dependencies            */
   P->Pf.PhiMin = 0.0;                           /* phi minimums            */
   P->Pf.PhiMax = 0.0;                           /* phi maximums            */
   P->Pf.ThetaMin = 0.0;                         /* theta minimums          */
   P->Pf.ThetaMax = 0.0;                         /* theta maximums          */
   P->Pf.ScanMin = 0.0;                          /* scan minimums           */
   P->Pf.ScanMax = 0.0;                          /* scan maximums           */
   P->Pf.MassMin = 0.0;                          /* mass minimums           */
   P->Pf.MassMax = 0.0;                          /* mass maximums           */
   P->Pf.ChargeMin = 0.0;                        /* charge minimums         */
   P->Pf.ChargeMax = 0.0;                        /* charge maximums         */
   P->Pf.EnergyMin = 0.0;                        /* energy minimums         */
   P->Pf.EnergyMax = 0.0;                        /* energy maximums         */
   P->Pf.FreqMin = 0.0;                          /* frequency minimums      */
   P->Pf.FreqMax = 0.0;                          /* frequency maximums      */
   P->Pf.Cyclic = 'N';                           /* phi cyclic              */
   P->Pf.SenType = 'S';                          /* sensor type             */

   P->Pq.LDesc = 0;                              /* quality long label      */
   P->Pq.SDesc = 0;                              /* quality abbr label      */
   P->Pq.NUnits = 0;                             /* quality num of units    */
   P->Pq.Units = 0;                              /* quality units pointer   */

   P->As.LDesc = 0;                              /* quality long label      */
   P->As.SDesc = 0;                              /* quality abbr label      */
   P->As.NUnits = 0;                             /* quality num of units    */
   P->As.Units = 0;                              /* quality units pointer   */

   P->Ap.LDesc = 0;                              /* quality long label      */
   P->Ap.SDesc = 0;                              /* quality abbr label      */
   P->Ap.NUnits = 0;                             /* quality num of units    */
   P->Ap.Units = 0;                              /* quality units pointer   */

   P->Pi.Format = '-';                           /* no image format         */
   P->Pi.Type = '-';                             /* no image type           */
   P->Pi.NLatLong = 0;                           /* no image lat/long defs  */
   P->Pi.BinType = '-';                          /* no image bin type       */
   P->Pi.Storage = 0;                            /* no image storage type   */

   for (I = 0; I < P->Pi.MLatLongs; ++I)         /* img lat/long struc loop */
       InitLatLong (PIDF, I);                    /* initialize              */

   for (I = 0; I < P->MSensors; ++I)             /* init sen structs loop   */
       InitSensor (PIDF, I);                     /* initialize              */

   for (I = 0; I < P->MUnits; ++I)               /* init unit structs loop  */
       InitUnit (PIDF, I);                       /* initialize              */

   for (I = 0; I < P->MScans; ++I)               /* init scan structs loop  */
       InitScan (PIDF, I);                       /* initialize              */

   for (I = 0; I < P->MBins; ++I)                /* init bin structs loop   */
       InitBin (PIDF, I);                        /* initialize              */

   for (I = 0; I < P->MModes; ++I)                /* init mode structs loop  */
       InitMode (PIDF, I);                        /* initialize              */

   for (I = 0; I < P->MAncil; ++I)                /* init mode structs loop  */
       InitAncil (PIDF, I);                       /* initialize              */
};
