#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "PidfStr.h"
#include "PidfAnsi.h"
#include "PidfRets.h"
#include "PidfDefs.h"
#include "libbase_udf.h"

ByTe_1 *GetPidfStr (u_ByTe_4 Key, void *PIDF, ByTe_2 Item, ByTe_2 N) 
{
   struct Pidf *P;
   struct PidfSensor *Px;
   struct PidfUnit *Pu;
   struct PidfMode *Pm;
   struct PidfAnc *Pa;
 
   ByTe_1 *S = 0, **G;

   ReadPidf (Key, PIDF);                          /* get Pidf Info          */
   
   P = (struct Pidf *) PIDF;                      /* PIDF interface struct   */ 

   switch (Item)                                  /* item switch             */
   {                                              /* BEGIN SWITCH ON ITEM    */
      case HEADER:                                /* START HEADER CASE       */
         switch (Item)                            /* field switch            */
         {                                        /* BEGIN SWITCH ON FIELD   */
            case InstitutE:                       /* START INSTITUTE CASE    */
               S = P->Pf.Institute;               /* set pointer             */
            break;                                /* STOP INSTITUTE CASE     */
            case ProjecT:                         /* START PROJECT CASE      */
               S = P->Pf.Project;                 /* set pointer             */
            break;                                /* STOP PROJECT CASE       */
            case MissioN:                         /* START MISSION CASE      */
               S = P->Pf.Mission;                 /* set pointer             */
            break;                                /* STOP MISSION CASE       */
            case ExpeR:                           /* START EXPERIMENT CASE   */
               S = P->Pf.Exper;                   /* set pointer             */
            break;                                /* STOP EXPERIMENT CASE    */
            case InsT:                            /* START INSTRUMENT CASE   */
               S = P->Pf.Inst;                    /* set pointer             */
            break;                                /* STOP INSTTUMENT CASE    */
            case VinsT:                           /* START VINST CASE        */
               S = P->Pf.Vinst;                   /* set pointer             */
            break;                                /* STOP VINST CASE         */
         }                                        /* END SWITCH ON FIELD     */
      break;                                      /* STOP HEADER CASE        */
      case GROUPS:                                /* START GROUPS CASE       */
         G = (ByTe_1 **)P->Groups;                /* grp name pointer        */
         S = G[N];                                /* set return pointer      */
      break;                                      /* STOP GROUPS CASE        */
      case UNITS:                                 /* START UNITS CASE        */
         Pu = (struct PidfUnit *)P->Units + N;    /* correct units struct    */
         switch (Item)                            /* field switch            */
         {                                        /* BEGIN SWITCH ON FIELD   */
            case NamE:                            /* START NAME CASE         */
               S = Pu->LDesc;                     /* set pointer             */
            break;                                /* STOP NAME CASE          */
            case AbbR:                            /* START ABBREVIATION CASE */
               S = Pu->SDesc;                     /* set pointer             */
            break;                                /* STOP ABBREVIATION CASE  */
            case UNamE:                           /* START UNITS NAME CASE   */
               S = Pu->ULab;                      /* set pointer             */
            break;                                /* STOP UNITS NAME CASE    */
         }                                        /* END SWITCH ON FIELD     */
      break;                                      /* STOP UNITS CASE         */
      case SENSORS:                               /* START SENSORS CASE      */
         Px = (struct PidfSensor *)P->Sensors + N; /* correct sensors struct */
         switch (Item)                            /* field switch            */
         {                                        /* BEGIN SWITCH ON FIELD   */
            case NamE:                            /* START NAME CASE         */
               S = Px->Name;                      /* set pointer             */
            break;                                /* STOP NAME CASE          */
            case ComP:                            /* START COMP NAME CASE    */
               S = Px->Comp;                      /* set pointer             */
            break;                                /* STOP COMP NAME CASE     */
            case ScfNamE:                         /* START SCF FILE CASE     */
               S = Px->ScfFile;                   /* set pointer             */
            break;                                /* STOP SCF FILE CASE      */
         }                                        /* END SWITCH ON FIELD     */
      break;                                      /* STOP SENSORS CASE       */
      case ANCIL:                                 /* START ANCIL CASE        */
         Pa = (struct PidfAnc *)P->Ancil + N;     /* correct ancil struct    */
         switch (Item)                            /* field switch            */
         {                                        /* BEGIN SWITCH ON FIELD   */
            case NamE:                            /* START NAME CASE         */
               S = Pa->LDesc;                     /* set pointer             */
            break;                                /* STOP NAME CASE          */
            case AbbR:                            /* START ABBREVIATION CASE */
               S = Pa->SDesc;                     /* set pointer             */
            break;                                /* STOP ABBREVIATION CASE  */
         }                                        /* END SWITCH ON FIELD     */
      break;                                      /* STOP ANCIL CASE         */
      case MODES:                                 /* START MODE CASE         */
         Pm = (struct PidfMode *)P->Modes + N;    /* correct modes struct    */
         switch (Item)                            /* field switch            */
         {                                        /* BEGIN SWITCH ON FIELD   */
            case NamE:                            /* START NAME CASE         */
               S = Pm->LDesc;                     /* set pointer             */
            break;                                /* STOP NAME CASE          */
            case AbbR:                            /* START ABBREVIATION CASE */
               S = Pm->SDesc;                     /* set pointer             */
            break;                                /* STOP ABBREVIATION CASE  */
         }                                        /* END SWITCH ON FIELD     */
      break;                                      /* STOP MODE CASE          */
      case PANG:                                  /* START PITCH ANG CASE    */
         switch (Item)                            /* field switch            */
         {                                        /* BEGIN SWITCH ON FIELD   */
            case NamE:                            /* START NAME CASE         */
               S = P->Ap.LDesc;                   /* set pointer             */
            break;                                /* STOP NAME CASE          */
            case AbbR:                            /* START ABBREVIATION CASE */
               S = P->Ap.SDesc;                   /* set pointer             */
            break;                                /* STOP ABBREVIATION CASE  */
         }                                        /* END SWITCH ON FIELD     */
      break;                                      /* STOP PITCH ANG CASE     */
      case SANG:                                  /* START SPIN ANGLE CASE   */
         switch (Item)                            /* field switch            */
         {                                        /* BEGIN SWITCH ON FIELD   */
            case NamE:                            /* START NAME CASE         */
               S = P->As.LDesc;                   /* set pointer             */
            break;                                /* STOP NAME CASE          */
            case AbbR:                            /* START ABBREVIATION CASE */
               S = P->As.SDesc;                   /* set pointer             */
            break;                                /* STOP ABBREVIATION CASE  */
         }                                        /* END SWITCH ON FIELD     */
      break;                                      /* STOP SPIN ANGLE CASE    */
      case QUALITY:                               /* START QUALITY CASE      */
         switch (Item)                            /* field switch            */
         {                                        /* BEGIN SWITCH ON FIELD   */
            case NamE:                            /* START NAME CASE         */
               S = P->Pq.LDesc;                   /* set pointer             */
            break;                                /* STOP NAME CASE          */
            case AbbR:                            /* START ABBREVIATION CASE */
               S = P->Pq.SDesc;                   /* set pointer             */
            break;                                /* STOP ABBREVIATION CASE  */
         }                                        /* END SWITCH ON FIELD     */
      break;                                      /* STOP QUALITY CASE       */
   }                                              /* END SWITCH ON ITEM      */
   return (S);
}
