#include "DbMesgs.h"
#include "libErrorMsgs.h"

/******************************************************************************
 |  >FILE:  db_msgs.c                                                         |
 |                                                                            |
 |  DESCRIPTION                                                               |
 |     This routine returns an element number of an experiment for a desired  |
 |  stream.                                                                   |
 |                                                                            |
 |  SYNOPSIS                                                                  |
 |     char *db_msgs(mesg_no)                                                 |
 |                                                                            |
 |  ARGUMENTS                                                                 |
 |     int mesg_no      message number                                        |
 |                                                                            |
 |  NECESSARY SUBPROGRAMS                                                     |
 |     None                                                                   |
 |                                                                            |
 |  EXTERNAL VARIABLES                                                        |
 |     None                                                                   |
 |                                                                            |
 |  INTERNAL VARIABLES                                                        |
 |     short i      loop counter                                              |
 |                                                                            |
 |  SUBSYSTEM                                                                 |
 |     DATABASE (Utility)                                                     |
 |                                                                            |
 ******************************************************************************/

static ByTe_1 *unknown = "UNKNOWN DB MESSAGE";
static ByTe_1 rcsid[] = "$Id: db_msgs.c,v 1.1 1999/11/20 19:17:23 chris.gurgiolo.b2r Stab chrisg $";

ByTe_1 *db_msgs(int mesg_no)
{
   register ByTe_2 i;
   ByTe_2 mN;

   /*
    | loop over all possible messages to find the matching message number
    */

   mN = (ByTe_2) (sizeof(db_mesg) / sizeof(struct db_messages));
   for (i=0; i<mN; i++)

      if (mesg_no == db_mesg[i].mesg_no)

         return db_mesg[i].message;

   return unknown;
}
