#include <stdio.h>
#include <time.h>
#include "OpSySInD.h"
#include "dbf.h"

/**********************************************
 ** Function:  int UpdateHeader(dbfrecord_t *D)
 **
 **    dbfrecord_t *d handle    pointer to database structure
 **
 ** Description:
 **    reset the header information and write it out to the database file
 **
 ** Return Values:
 **    * FAILURE - dbf_code set to actual error
 **    * SUCCESS - the routine completed without error
 **
 **********************************/

static ByTe_1 rcsid[] = "$Id: UpdateHeader.c,v 1.1 1999/11/13 17:45:28 chris.gurgiolo.b2r Stab chrisg $";

int UpdateHeader(dbfRecord_t *D)
{
   struct tm *mytm;
   time_t Sec;
#ifndef WIN32
   off_t offset;
#else
   long offset;
#endif
   int r;

   r = D->NumRecs;

   /*
    | get the date of the file for the header information
    */

   Sec = time ((time_t *)0);
   mytm = localtime(&Sec);

   /*
    | be sure to write it out the date of the file in the correct database file
    | type format
    */
   if (D->HeadProlog[0] == DB2File)
   {
      D->HeadProlog[5] = mytm->tm_year; /* Year           */
      D->HeadProlog[3] = mytm->tm_mon;  /* Month of year  */
      D->HeadProlog[4] = mytm->tm_mday; /* Day of month   */
      D->HeadProlog[2] = r/256;
      r -= D->HeadProlog[5]*2560;
      D->HeadProlog[1] = r;
   }
   else     
   {
      D->HeadProlog[1] = mytm->tm_year; /* Year           */
      D->HeadProlog[2] = mytm->tm_mon;  /* Month of year  */
      D->HeadProlog[3] = mytm->tm_mday; /* Day of month   */

      D->HeadProlog[7] = (ByTe_1) (r/16777216);
      r -= ((u_ByTe_1)D->HeadProlog[7] * 16777216);
      D->HeadProlog[6] = (ByTe_1) (r/65536);
      r -= ((u_ByTe_1)D->HeadProlog[6] * 65536);
      D->HeadProlog[5] = (ByTe_1) (r/256);
      r -= ((u_ByTe_1)D->HeadProlog[5] * 256);
      D->HeadProlog[4] = (ByTe_1)r;
   }

   /*
    | the header information goes at the beginning of the file, lseek to it.
    | If lseeking to the offset position does not retuen the offset, and error
    | has occured, return an lseek error.
    */
   offset = 0;
   if (lseek(D->dFile, offset, SEEK_SET) < offset)
   {
      dbf_code = LSEEK_ERROR;
      sprintf(msg, "'%s'", D->FileName);
      return FAILURE;
   }
   
   /*
    | if there is no problem in seeking to the beginning of the file write
    | out the header information
    */
   if (write(D->dFile, D->HeadProlog, 8) < 8)
   {
      dbf_code = WRITE_ERROR;
      sprintf(msg, "'%s'", D->FileName);
      return FAILURE;
   }

   /*
    | reset the status of the header info indicating that it matches the info
    | in the file
    */
   D->hStatus = NotUpdated;

   return SUCCESS;
}
