#include "dbf.h"

/**********************
 ** >FILE: GoToBottom.c
 **********************/

/**********************************************
 ** Function:  int GoToBottom(int dbf, int ndx)
 **
 **    int dbf   heandle to database structure
 **
 ** Description:
 **
 ** Return Values:
 **
 **********************************/

static ByTe_1 rcsid[] = "$Id: GoToBottom.c,v 1.1 1999/11/13 17:45:28 chris.gurgiolo.b2r Stab chrisg $";

int GoToBottom(int dbf, int ndx)
{
   dbfRecord_t *D;
   ndxRecord_t *N;

   if ((D = GetOldDbfHandle(dbf)) == NULL) 
      return FAILURE;

   if (ndx != -1)
   {
      if ((N = GetOldNdxHandle(dbf, ndx)) == NULL) 
         return FAILURE;

      N->IndexRec = D->NumRecs;
      return(GetDbfRecord(dbf, ItoR(N, N->IndexRec)));
   }

   return(GetDbfRecord(dbf, D->NumRecs));
}
