#include <string.h>
#include <errno.h>
#include "dbf.h"

/**********************************************************
 ** Function:  ndxRecord *GetOldNdxHandle(int dbf, int ndx)
 **
 ** Description:
 **    return the pointer to the database structure for the given handle.
 **
 ** Return Values:
 **   NULL - handle invalid, check dbf_code for explination
 **   Upon valid handle a pointer to the database structure is returned
 **
 **********************************/

static ByTe_1 rcsid[] = "$Id: GetOldNdx.c,v 1.1 1999/11/13 17:45:28 chris.gurgiolo.b2r Stab chrisg $";

ndxRecord_t *GetOldNdxHandle(int dbf, int ndx)
{
   ndxRecord_t *N;

   /*
    * find the currect handle
    * couldn't find this handle??, error!
    */
   if ((N=ndxHandle(dbf, ndx)) == NULL)
      return NULL;
   
   if (N->Index == NULL)
   {
      dbf_code = EMPTY_HANDLE;
      dbf_msg_clr;
      return NULL;
   }

   return N;
}
