#include <string.h>
#include <errno.h>
#include "dbf.h"

/******************************************************
 ** Function:  dbfRecord_t *GetOldDbfHandle(int handle)
 **
 ** Description:
 **    return the pointer to the database structure for the given handle.
 **
 ** Return Values:
 **   NULL - handle invalid, check dbf_code for explination
 **   Upon valid handle a pointer to the database structure is returned
 **
 **********************************/

static ByTe_1 rcsid[] = "$Id: GetOldDbf.c,v 1.1 1999/11/13 17:45:28 chris.gurgiolo.b2r Stab chrisg $";

dbfRecord_t *GetOldDbfHandle(int handle)
{
   dbfRecord_t *D;

   /*
    * find the currect handle
    * couldn't find this handle??, error!
    */
   if ((D=dbfHandle(handle)) == NULL)
      return NULL;
   
   if (D->dFile == -1)
   {
      dbf_msg_clr;
      dbf_code = EMPTY_HANDLE;
      return NULL;
   }

   return D;
}
