#include <stdio.h>
#include <string.h>
#include "dbf.h"

static ByTe_1 rcsid[] = "$Id: DeleteRec.c,v 1.1 1999/11/13 17:45:28 chris.gurgiolo.b2r Stab chrisg $";

int DeleteRec(int dbf, int ndx, int rec)
{
   dbfRecord_t *D;
   ndxRecord_t *N = 0;

   if ((D = GetOldDbfHandle(dbf)) == NULL)
      return FAILURE;

   if (ndx != -1)
   {
      if ((N = GetOldNdxHandle(dbf, ndx)) == NULL)
         return FAILURE;

      if (GoTo(dbf, ItoR(N, rec)) != SUCCESS)
         return FAILURE;

   }
   else
      if (GoTo(dbf, rec) != SUCCESS)
         return FAILURE;

   if (D->CurRecord[0][0] == ' ')
   {
      D->CurRecord[0][0] = '*';

      if (N)
         DeleteNdxRec(N, ItoR(N, rec));

      return PutDbfRecord(dbf, rec);
   }

   return SUCCESS;
}
