#include <stdio.h>
#include "dbf.h"

/***********************
 ** >FILE: AppendBlank.c
 ***********************/

/****************************************
 ** Function:  int AppenBlank(int handle)
 **
 **    int handle    handle to database structure
 **
 ** Description:
 **    This subroutine append a blank record to the database.  Any character
 ** fields are initializes to spaces while the numeric fields are set to 0.
 ** If, before the append, the current record has not been updated it is
 ** written to the database.  If an error occurs, and error number is
 ** returned to the calling routine.
 **
 ** Return Values:
 **
 **********************************/

static ByTe_1 rcsid[] = "$Id: AppendBlank.c,v 1.1 1999/11/13 17:45:28 chris.gurgiolo.b2r Stab chrisg $";

int AppendBlank(int handle)
{
   dbfRecord_t *D;
   FieldRecord_t *fld;
   int i, j, rval;


   if ((D = GetOldDbfHandle(handle)) == NULL)
		return FAILURE;

   /*
    | if the current record needs writing out then do so
    */
   if (D->rStatus == Updated)
   {
      if ((rval = PutDbfRecord(handle, D->CurRec)) != SUCCESS)
      {
         return rval;
      }
   }

   /*
    | clear all fields
    */
   for (i=0; i<D->NumFields; i++)
   {
      fld = &D->Fields[i];

      switch (fld->Typ)
      {
         /*
          | put spaces in for the character type
          */
         case CHARACTER:
            for (j=0; j<fld->Len; j++)
            {
               *(fld->Parm + j) = ' ';
            }

            break;

         /*
          | for the numeric type reset the value to zero
          */
         case NUMERIC:
            if (fld->Dec == 0)
            {
               (void)sprintf(fld->Parm, "%*d", fld->Len, (int)0);
            }
            else
            {
               (void)sprintf(fld->Parm, "%*.*f", fld->Len, fld->Dec, (ReaL_4) 0.0);
            }

            break;
      } 
   } 

   /*
    | indicate this record is NOT deleted
    */
   D->CurRecord[0][0] = ' ';
 
   /*
    | append it to the database and return the status from appending
    */
   return(AppendDbf(handle));
}
