#include <stdio.h>
#include <string.h>
#include "dbf.h"

/*****************
 ** >FILE: dbField.c
 *****************/

/***********************************************************
 ** Function:  FieldRecord_t *dbField(int handle, char *name)
 **
 **    int handle     handle to the database structure
 **    char *name     the name of the field
 **
 ** Description:
 **    This subroutine returns a pointer to the field associated by name.
 **
 ** Return Values:
 **
 **********************************/

static ByTe_1 rcsid[] = "$Id: dbField.c,v 1.1 1999/11/13 17:45:28 chris.gurgiolo.b2r Stab chrisg $";

FieldRecord_t *dbField(int handle, ByTe_1 *name)
{
   dbfRecord_t *D;
   int i;

   
   if ((D = GetOldDbfHandle(handle)) == NULL)
      return NULL;

   for (i=0; i<D->NumFields; i++)
   {
      if (strcmp(name, D->Fields[i].Name) == 0)
      {
         dbf_msg_clr;
         dbf_code = 0;
         return &D->Fields[i];
      }
   }

   sprintf(msg, "'%s' in '%s'", name, D->FileName);
   dbf_code = UNKNOWN_FIELD;
   return NULL;
}
