#include <stdio.h>
#include <string.h>
#include "dbf.h"

static ByTe_1 rcsid[] = "$Id: UnDeleteRec.c,v 1.1 1999/11/13 17:45:28 chris.gurgiolo.b2r Stab chrisg $";

int UnDeleteRec(int dbf, int ndx, int rec)
{
   dbfRecord_t *D;
   ndxRecord_t *N = 0;
   int ret;

   if ((D = GetOldDbfHandle(dbf)) == NULL)
      return FAILURE;

   if (ndx != -1)
      if ((N = GetOldNdxHandle(dbf, ndx)) == NULL)
         return FAILURE;

   if (GoTo(dbf, rec) != SUCCESS)
      return FAILURE;

   if (D->CurRecord[0][0] == '*')
   {
      D->CurRecord[0][0] = ' ';

      if ((ret=PutDbfRecord(dbf, rec)) == SUCCESS)
         if (N)
            ret = AddIndexRec(D, N);

      return ret;
   }

   return SUCCESS;
}
