#include <stdio.h>
#include <string.h>
#include "dbf.h"

/****************
 ** >FILE: Skip.c
 ****************/

/***********************************************
 ** Function:  int Skip(int dbf, int ndx, int n)
 **
 ** Description:
 **    This routine skips s records form the current record.  If the skip
 ** goes past the end of the database an error is returned, however if the
 ** skip goes past the beginning of the file then the returned record will
 ** be the 1st record in the database.  If an index file has been opened
 ** then the skip will be based on the index.
 **
 ** Return Values:
 **
 **********************************/

static ByTe_1 rcsid[] = "$Id: Skip.c,v 1.1 1999/11/13 17:45:28 chris.gurgiolo.b2r Stab chrisg $";

int Skip(int dbf, int ndx, int s)
{
   dbfRecord_t *D;
   ndxRecord_t *N = NULL;
   int rec, rval;


   if ((D = GetOldDbfHandle(dbf)) == NULL)
      return FAILURE;

   /*
    | check the range of the record number
    */
   if (ndx == -1)
   {
      rec = D->CurRec + s;
   }
   else
   {
      if ((N = GetOldNdxHandle(dbf, ndx)) == NULL) 
         return FAILURE;

      if ((N->IndexRec + s) > N->NextFreeIndexRec)
      {
         sprintf(msg, "'%s'", N->IndexName);
         dbf_code = REC_TOO_HIGH;
         return FAILURE;
      }
      else if ((N->IndexRec + s) <= 0)
      {
         s = -(N->IndexRec - 1);
      }

      rec = ItoR(N, N->IndexRec+s);
   }

   /*
    | read the database record
    */
   if ((rval = GetDbfRecord(dbf, rec)) == SUCCESS)
   {
      if (ndx != -1)
      {
         N->IndexRec += s;
      }
   }

   dbf_msg_clr;
   dbf_code = 0;
   return rval;
}
