#include <stdio.h>
#include <string.h>
#include "OpSySInD.h"
#include <errno.h>

#include "dbf.h"

/**************************************************
 ** Function:  int ProcessHeader(dbfRecord_t *D,
 **                             Header_t Header,
 **                             int NumBytes)
 **
 ** Description:
 **    Decode the header
 **
 ** Return Values:
 **    * FAILURE - dbf_code set to actual error
 **    * SUCCESS - the routine completed without error
 **
 **********************************/

static ByTe_1 rcsid[] = "$Id: ProcessHeader.c,v 1.1 1999/11/13 17:45:28 chris.gurgiolo.b2r Stab chrisg $";

int ProcessHeader(dbfRecord_t *D, Header_t Header, int NumBytes)
{
   int i, o, rval;
   unsigned int nbytes;
   FieldArray_t tempFields;

   /*
    | determine file type, must be a DBase III file
    */
   switch(Header[0])
   {
      case DB2File:
         (void)fprintf(stderr, "File Type: Dbase II\n");

         dbf_code = NOT_DB_FILE;
         sprintf(msg, "'%s'", D->FileName);
         return FAILURE;

         break;

      case DB3File:
         break;

      case DB3WithMemo:
         (void)fprintf(stderr, "File Type: Dbase III w/memo\n");

         dbf_code = NOT_DB_FILE;
         sprintf(msg, "'%s'", D->FileName);
         return FAILURE;

         break;

      default:
         (void)fprintf(stderr, "File Type: UNKNOWN\n");

         sprintf(msg, "'%s'", D->FileName);
         dbf_code = NOT_DB_FILE;
         return FAILURE;

         break;
   }

   /*
    | decode the data of the last update to the database file
    */
   (void)sprintf(D->DateOfUpdate, "%2d/%02d/%02d", Header[2], Header[3], Header[1]);

   /*
    | number of records in the database file
    */
   D->NumRecs = MakeLong(&Header[4]);

   /*
    | get the size of the header
    */
   D->HeadLen = MakeInt(&Header[8]);

   if (NumBytes < D->HeadLen)
   { 
      (void)fprintf(stderr, "Not A Dbase File\n");

      sprintf(msg, "'%s'", D->FileName);
      dbf_code = NOT_DB_FILE;
      return FAILURE;
   }

   /*
    | the size of each record
    */
   D->RecLen = MakeInt(&Header[10]);

   /*
    | allocate some space for the current database record, if an error occurs
    | return error number
    */
   if ((D->CurRecord = (DataRecord_t *)calloc(1, D->RecLen)) == NULL)
   {
      dbf_msg_clr;
      dbf_code = errno;
      return FAILURE;
   }

   /*
    | set the current status for the header in to 'NotUpdated', if this gets
    | changed to 'Updated' the header info will need to be re-written
    */
   D->hStatus = NotUpdated;

   /*
    | copy the current header info to a buffer in the database structure to
    | keep
    */
   memcpy((ByTe_1 *)D->HeadProlog, (ByTe_1 *)Header, (int)sizeof(HeaderProlog_t));

   /*
    | no fields defined yet, set to zero
    */
   D->NumFields = 0;

   /*
    | loop until all field definitions are complete
    */
   o = 1;
   i = 32;
   while (Header[i] != 0xD)
   {

      /* 
       | decode each field description
       */
      if ((rval = GetOneFieldDesc(D, (FieldDesc_t *)&Header[i],
                                &tempFields[D->NumFields], &o)) != SUCCESS)
      {
         return rval;
      }

      /*
       | increment the number of fields in this header
       */
      D->NumFields++;

      i += 32;
   }
 
   /*
    | all the fields have been defined, allocate space for them and copy them
    | to the database structure
    */
   if ((D->Fields = (FieldRecord_t *)calloc(D->NumFields, sizeof(FieldRecord_t))) == NULL)
   {
      dbf_msg_clr;
      dbf_code = errno;
      return FAILURE;
   }

   nbytes = D->NumFields * sizeof(FieldRecord_t);
   memcpy((ByTe_1 *)D->Fields, (ByTe_1 *)tempFields, (int)nbytes);

   return SUCCESS;
}
