#include <stdio.h>
#include <string.h>
#include "OpSySInD.h"
#include "libbase_udf.h"
#include <errno.h>
#include "dbf.h"

/*******************
 ** >FILE: OpenNdx.c
 *******************/

/***********************************************************
 ** Function:  int OpenNdx(int dbf, char *fname, int ndx)
 **
 ** Description:
 **    This routine opens and reads the index array and sets all necessary
 ** variables in the database structure D.
 **
 ** Return Values:
 **
 **********************************/

static ByTe_1 rcsid[] = "$Id: OpenNdx.c,v 1.1 1999/11/13 17:45:28 chris.gurgiolo.b2r Stab chrisg $";

int OpenNdx(int dbf, ByTe_1 *fname, int *ndx)
{
   extern ByTe_1 BswaP;                                            

   register u_ByTe_1 *c1, *c2;
   u_ByTe_1 *cA, *cB, *cC, *cD, cT;
   ndxRecord_t *N;
   ByTe_1 iHeader[96];
   int I, fd, n;
   ByTe_4 nbytes, Offset, TotLen;
   ByTe_1 *Sep = PathSep;

   FieldRecord_t *fld;


  if ((N = GetNewNdxHandle(dbf, ndx)) == NULL)
      return FAILURE;

   /*
    | open the index file
    */

   strcpy(N->IndexName, fname);
   if (Sep[0] != '/') {                          /* Non-Unix path separator */
      c1 = N->IndexName;                         /* path pointer            */
      while (*c1 != 0) {                         /* loop over path          */
        if (*c1 == '/') { *c1 = Sep[0]; }        /* change dir separator    */
        ++c1;                                    /* advance pointer         */
      }                                          /* END PATH LOOP           */
   }                                             /* END SUBSTITUTION        */

   if ((fd = open(N->IndexName, O_RDONLY)) < 0)
   {
      sprintf(msg, "'%s'", N->IndexName);
      dbf_code = errno;
      return FAILURE;
   }

#ifdef _CyGnUsC
   setmode (fd, O_BINARY);
#endif
#ifdef WIN32
      _setmode (fd, O_BINARY);
#endif


   /*
    | read the header info and set the next free index record, the maximum
    | number of indexes available and the number of index records.
    */
   memset(iHeader, 0, sizeof(iHeader));
   if ((n = read(fd, (ByTe_1 *)iHeader, sizeof(iHeader))) < 0)
   {
      sprintf(msg, "'%s'", N->IndexName);
      dbf_code = READ_ERROR;
      return FAILURE;
   }

   N->NumIndexFields   = *((int *)&iHeader[12]);
   if ( N->NumIndexFields > 63000 ) {
      ReOrderBytes (4, (u_ByTe_1 *)&iHeader[4], 3);
      c2 = (u_ByTe_1 *)&iHeader[4];
      cA = c2; cB = cA + 1; cC = cB + 1; cD = cC + 1;
      cT = *cA; *cA = *cD; *cD = cT;
      cT = *cB; *cB = *cC; *cC = cT;
      c2 += 4;
      cA = c2; cB = cA + 1; cC = cB + 1; cD = cC + 1;
      cT = *cA; *cA = *cD; *cD = cT;
      cT = *cB; *cB = *cC; *cC = cT;
      c2 += 4;
      cA = c2; cB = cA + 1; cC = cB + 1; cD = cC + 1;
      cT = *cA; *cA = *cD; *cD = cT;
      cT = *cB; *cB = *cC; *cC = cT;
      BswaP = 1; 
   }
   
   N->NextFreeIndexRec = *((int *)&iHeader[4]);
   N->MAXIndexRecs     = *((int *)&iHeader[8]);
   N->NumIndexFields   = *((int *)&iHeader[12]);

   /*
    | allocate the necesary memory for the index fields
    */
   nbytes = N->NumIndexFields * sizeof(FieldRecord_t);

   if ((N->IndexFields = (FieldRecord_t *)calloc(N->NumIndexFields,
                                                sizeof(FieldRecord_t))) == NULL)
   {
      dbf_msg_clr;
      dbf_code = errno;
      return FAILURE;
   }

   /*
    | set the index fields
    */
   nbytes = 0;
   N->KeyLen = 0;

   for (I=0; I<N->NumIndexFields; I++)
   {
      memcpy((N->IndexFields+I)->Name, &iHeader[I*16 + 16], FIELD_NAME_LEN);
      memcpy((ByTe_1 *)&(N->IndexFields+I)->Typ, &iHeader[I*16 + 16 + FIELD_NAME_LEN], 3);

      if ((fld = dbField(dbf, (N->IndexFields+I)->Name)) == NULL)
      {
         return FAILURE;
      }
      (N->IndexFields+I)->Parm = fld->Parm;
      
      N->KeyLen += (N->IndexFields+I)->Len;
   }

   /*
    | allocate the necessay memory for the index array
    */
   nbytes += N->KeyLen + ALIGN(N->KeyLen) + sizeof(int);

   if ((N->Index = calloc(N->MAXIndexRecs, nbytes)) == NULL)
   {
      dbf_msg_clr;
      dbf_code = errno;
      return FAILURE;
   }

   /*
    | read the index array
    */

   TotLen = nbytes;
   nbytes *= N->MAXIndexRecs;
   if ((n = read(fd, (ByTe_1 *)N->Index, nbytes)) < 0)
   {
      sprintf(msg, "'%s'", N->IndexName);
      dbf_code = errno;
      return FAILURE;
   }


   if (BswaP == 1 ) {
      c1 = (u_ByTe_1 *)N->Index;
      Offset = TotLen - 4;
      for (I = 0; I < N->MAXIndexRecs; ++I, c1 += TotLen) {
         c2 = c1 + Offset; 
	 cA = c2; cB = cA + 1; cC = cB + 1; cD = cC + 1;
         cT = *cA; *cA = *cD; *cD = cT;
	 cT = *cB; *cB = *cC; *cC = cT;
      }
   }

   /*
    | the index file is no longer needed, close it
    */
   (void)close(fd);

   N->iStatus = NotUpdated;
   dbf_msg_clr;
   dbf_code = 0;
   return SUCCESS;
}
