#include <stdio.h>
#include <time.h>
#include <errno.h>
#include <ctype.h>
#include <string.h>
#include "OpSySInD.h"
#include "dbf.h"

/******************************************************
 ** Function:  int MakeOneFieldDesc(dbfRecord_t *D,
 **                                 FieldDesc_t *F,
 **                                 FieldRecord_t *Field)
 **
 **    dbfRecord_t *D      - pointer to database structure
 **    FieldDesc_t *F      - pointer to source field information
 **    FieldRecord_t *Field - pointer to destination field information
 **
 ** Description:
 **    define one field (copy the field into the header)
 **
 ** Return Values:
 **
 **********************************/

static ByTe_1 rcsid[] = "$Id: MakeOneFldDesc.c,v 1.1 1999/11/13 17:45:28 chris.gurgiolo.b2r Stab chrisg $";

int MakeOneFieldDesc(dbfRecord_t *D, FieldDesc_t *F, FieldRecord_t *Field)
{
   /*
    | copy the field info into the header
    */
   if (islower(Field->Typ))
      Field->Typ = toupper(Field->Typ);
   memcpy(F, &Field->Name[0], 10);

   /*
    | set the type and length of the field
    */
   *(*F+11) = Field->Typ;
   *(*F+16) = Field->Len;

   switch(Field->Typ)
   {
      case MEMO:
         D->WithMemo = TRUE;
      case CHARACTER:
      case DATE:
      case LOGICAL:
         Field->Dec = 0;
         break;

      /*
       | decimals will only exist of the field is numeric
       */
      case NUMERIC:
         *(*F+17) = Field->Dec;
         break;

      default:
         sprintf(msg, "Unknown field type '%c' for field name: '%s'\n",
                 Field->Typ, Field->Name);

         dbf_code = UNKNOWN_FIELD_TYPE;
         return FAILURE;
   }


   /*
    | increment the record size by the length of the field
    */
   D->RecLen += Field->Len;

   return SUCCESS;
}
