#include <stdio.h>
#include <time.h>
#include <errno.h>
#include <ctype.h>
#include <string.h>
#include "OpSySInD.h"
#include "dbf.h"

/*
 |
 ||
 ||| MakeFieldDescs() - define all fields, store the info in the header buffer
 ||
 |
 */

static ByTe_1 rcsid[] = "$Id: MakeFldDescs.c,v 1.1 1999/11/13 17:45:28 chris.gurgiolo.b2r Stab chrisg $";

int MakeFieldDescs(dbfRecord_t *D, FieldRecord_t *Flds)
{
   extern Header_t tHeader;
   int i, rval;

   /*
    | start with the record length of 1, this element will be used to determine
    | if this record has been deleted or not; '*' means deleted while ' ' means
    | this record is not deleted
    */
   D->RecLen = 1;

   /*
    | loop over all fields
    */
   for (i=1; i<=D->NumFields; i++)
   {
      if ((rval=MakeOneFieldDesc(D, (FieldDesc_t *)&tHeader[i*32], Flds++)) != SUCCESS)
      {
         return rval;
      }
   }

   return SUCCESS;
}
