#include "dbf.h"

/****************
 ** >FILE: ItoR.c
 ****************/

/*******************************************
 ** Function:  int ItoR(ndxRecord_t *N, int i)
 **
 ** Description:
 **    This routine converts the index number to a plain record number to be
 ** used by GetDbfRecord().
 **
 ** Return Values:
 **    record number of database (absolute)
 **
 **********************************/

static ByTe_1 rcsid[] = "$Id: ItoR.c,v 1.1 1999/11/13 17:45:28 chris.gurgiolo.b2r Stab chrisg $";

int ItoR(ndxRecord_t *N, int i)
{
   int rec;

   rec = *((int *)(N->Index +
          ((N->KeyLen + ALIGN(N->KeyLen) + sizeof(int)) * (i-1)) + 
          N->KeyLen + ALIGN(N->KeyLen)));

   return rec;
}
