#include <string.h>
#include <errno.h>
#include "dbf.h"

/*******************************************
 ** Function:  InitDbfHandle(dbfRecord_t *d)
 **
 ** Description:
 **    initialize a handle's structure to a known state
 **
 ** Return Values:
 **    None
 **
 **********************************/

static ByTe_1 rcsid[] = "$Id: InitDbf.c,v 1.1 1999/11/13 17:45:28 chris.gurgiolo.b2r Stab chrisg $";

int InitDbfHandle(dbfRecord_t *D)
{
   /*
    * initialize all the fields of the structure
    */
   memset(D->FileName, 0, sizeof(D->FileName));
   D->dFile = -1;

   memset(D->HeadProlog, 0, sizeof(HeaderProlog_t));
   D->hStatus = NotOpen;
   D->WithMemo = 0;
   memset(D->DateOfUpdate, 0, sizeof(D->DateOfUpdate));
   D->NumRecs = 0;
   D->HeadLen = 0;
   D->RecLen = 0;
   D->NumFields = 0;
   D->Fields = NULL;
   D->CurRec = -1;
   D->rStatus = NotOpen;
   D->CurRecord = NULL;

   D->ndxRecords = NULL;

   D->next = NULL;

   return SUCCESS;
}
