#include <string.h>
#include <errno.h>
#include "dbf.h"

/****************************************************************
 ** Function:  ndxRecord_t *GetNewNdxHandle(int dbf, int *handle)
 **
 ** Description:
 **    return the handle to a new index structure
 **
 ** Return Values:
 **   * -1 - cannot get a new handle, check dbf_code for explination
 **   * Valid handle number (starting at 0)
 **
 **********************************/

static ByTe_1 rcsid[] = "$Id: GetNewNdx.c,v 1.1 1999/11/13 17:45:28 chris.gurgiolo.b2r Stab chrisg $";

ndxRecord_t *GetNewNdxHandle(int dbf, int *handle)
{
   dbfRecord_t *D;
   ndxRecord_t *N;

   if ((D=dbfHandle(dbf)) == NULL)
      return NULL;

   if (D->ndxRecords == NULL)
   {
      /*
       * no index structures initializes as yet
       */
      if ((D->ndxRecords = (ndxRecord_t *) calloc(1, sizeof(ndxRecord_t))) == NULL)
      {
         dbf_code = errno;
         dbf_msg_clr;
         return NULL;
      }
      N = D->ndxRecords;
      N->handle = 1;
   }
   else
   {
      /*
       * need a new handle, allocate a new one and append it to the end
       * of the list of current handles
       */
      for (N = D->ndxRecords; N->next != NULL; N = N->next);  /* last handle */

      if ((N->next = (ndxRecord_t *) calloc(1, sizeof(ndxRecord_t))) == NULL)
      {  
         dbf_code = errno;
         dbf_msg_clr;
         return NULL;
      }  
      N->next->handle = N->handle + 1;
      N = N->next;
   }
  
   InitNdxHandle(N);

   *handle = N->handle;
   return N;
}
