#include <stdio.h>
#include <string.h>
#include "OpSySInD.h"
#include "libbase_udf.h" 
#include <errno.h>

#include "dbf.h"

/*******************************************
 ** Function:  int GetHeader(dbfRecord_t *D)
 **
 ** Description:
 **    Preform the read of the header information in the database file and
 ** decode the field definitions
 **
 ** Return Values:
 **    * FAILURE - dbf_code set to actual error
 **    * SUCCESS - the routine completed without error
 **
 **********************************/

static ByTe_1 rcsid[] = "$Id: GetHeader.c,v 1.1 1999/11/13 17:45:28 chris.gurgiolo.b2r Stab chrisg $";

int GetHeader(dbfRecord_t *D)
{
   Header_t H;
   int nbytes;

   /*
    | read the header information (up to MAX_HEADER bytes), on error return
    */

   if ((nbytes = read(D->dFile, H, MAX_HEADER)) < 0)
   {
      sprintf(msg, "'%s'", D->FileName);
      dbf_code = READ_ERROR;
      return FAILURE;
   }

   /*
    | was able to read the header information, now decode it and return the
    | status from the decoding
    */
   return(ProcessHeader(D, H, nbytes));
}
