#include <string.h>
#include <math.h>
#include <stdio.h>
#include "dbf.h"

/*********************
 ** >FILE: FieldPut.c
 *********************/

/*******************************************************
 ** Function:  int FieldPut(int dbf, int fn, void *data)
 **
 ** Description:
 **    This routine replaces the info in the field with the info pointed to
 ** by data.
 **
 ** Return Values:
 **
 **********************************/

static ByTe_1 rcsid[] = "$Id: FieldPut.c,v 1.1 1999/11/13 17:45:28 chris.gurgiolo.b2r Stab chrisg $";

int FieldPut(int dbf, int fn, void *data)
{
   dbfRecord_t *D;
   FieldRecord_t *fld;
   ByTe_1 *cptr;
   int j;
   

   if ((D = GetOldDbfHandle(dbf)) == NULL)
      return FAILURE;

   if (fn >= D->NumFields || fn < 0)
   {
      dbf_msg_clr;
      dbf_code = UNKNOWN_FIELD;
      return FAILURE;
   }
   fld = D->Fields + fn;

   /*
    | make sure we replace based on the variable type
    */
   switch(fld->Typ)
   {
      case CHARACTER:
         cptr = (ByTe_1 *) data;
         for (j=0; j<fld->Len && *cptr != '\0'; j++)
            fld->Parm[j] = *cptr++;

         /*
          | pad with spaces
          */
         for (; j<fld->Len; j++)
         {
            fld->Parm[j] = ' ';
         }
 
         break;

      case NUMERIC:
         {
            ByTe_1 dummy[20];
            ByTe_1 fmt[64];

            if (fld->Dec == 0)
            {
               /*
                * build format string for an integer and then put it into
                * a string
                */
               sprintf(fmt, "%%%dld", fld->Len);
               sprintf(dummy, fmt, *((ByTe_4 *) data));
            }
            else
            {
               /*
                * build format string for an integer and then put it into
                * a string
                */
               sprintf(fmt, "%%%d.%dlf", fld->Len, fld->Dec);
               sprintf(dummy, fmt, *((ReaL_8 *) data));
            }

            if (strlen(dummy) > fld->Len)
            {
               dbf_msg_clr;
               dbf_code = FIELD_VALUE_ERR;
               return FAILURE;
            }
            memcpy(fld->Parm, dummy, fld->Len);
         }
         break;

      case DATE:
         memcpy(fld->Parm, (ByTe_1*)data, fld->Len);
         break;

      default:
         sprintf(msg, "'%c'", fld->Typ);
         dbf_code = UNKNOWN_FIELD_TYPE;
         break;
   }

   /*
    | set the status of the current record to Updated so it will be written out
    | on the next chance
    */
   D->rStatus = Updated;

   return SUCCESS;
}
