#include <math.h>
#include <string.h>
#include <stdio.h>
#include "dbf.h"

static ByTe_1 rcsid[] = "$Id: FieldGet.c,v 1.1 1999/11/13 17:45:28 chris.gurgiolo.b2r Stab chrisg $";

int FieldGet(int dbf, int fn, void *data)
{
   dbfRecord_t *D;
   FieldRecord_t *fld;
   ByTe_1 *cptr, num[64];
   ByTe_4 *lptr;
   ReaL_8 *dptr;


   if ((D = GetOldDbfHandle(dbf)) == NULL)
      return FAILURE;

   if (fn >= D->NumFields || fn < 0)
   {
      return FAILURE;
   }
   fld = D->Fields + fn;
    
   switch (fld->Typ)
   {
      case CHARACTER:
         cptr = (ByTe_1 *)data;
         sprintf(cptr, "%*.*s", fld->Len, fld->Len, fld->Parm);
         break;

      case NUMERIC:
         memset(num, 0,  sizeof(num));
         sprintf(num, "%*.*s", fld->Len, fld->Len, fld->Parm);

         if (fld->Dec == 0)
         {
            lptr = (ByTe_4 *)data;
            *lptr = atol(num);
         } else
         {
            dptr = (ReaL_8 *)data;
            *dptr = atof(num);
         }
         break;

      case DATE:
         strncpy((ByTe_1*)data, fld->Parm, 8);
         break;
   }

   return SUCCESS;
}
