#include <stdio.h>
#include <string.h>
#include "dbf.h"

static ByTe_1 rcsid[] = "$Id: DbfMsg_2.c,v 1.1 1999/11/13 17:45:28 chris.gurgiolo.b2r Stab chrisg $";

ByTe_1 *_dbf_msg()
{
   switch(dbf_code)
   {
      case SUCCESS : return "dbf: No error or warnings";

      case FULL           : return "dbf: allocated databases full";
      case NOT_DB_FILE    : return "dbf: not a xbase type file";
      case REC_TOO_HIGH   : return "dbf: record number too high (out of range)"; 
      case REC_TOO_LOW    : return "dbf: record number too low (out of range)"; 
      case PARTIAL_READ_  : return "dbf: partial read error"; 
      case LSEEK_ERROR    : return "dbf: lseek error";
      case READ_ERROR     : return "dbf: read error";
      case WRITE_ERROR    : return "dbf: write error";
      case OPEN_ERROR     : return "dbf: file open error";

      case UNKNOWN_FIELD_TYPE : return "dbf: unknown field type";
      case UNKNOWN_FIELD      : return "dbf: unknown field";
      case FIELD_VALUE_ERR    : return "dbf: field value error";
      case FIELD_ERROR        : return "dbf: field error";

      case NO_SUCH_HANDLE   : return "dbf: no such handle";
      case EMPTY_HANDLE     : return "dbf: empty handle";
      case NO_AVAIL_HANDLES : return "dbf: no handles available";
      case UNKNOWN_HANDLE   : return "dbf: unknown handle";

      case INVALID_SET_CMD : return "dbf: invalid set command";
      case INVALID_SET_VALUE : return "dbf: invalid set value";

      default: return "dbf: unknown error or warning code";
   }
}
#ifdef GIGO
    case SC_EXISTS   :  return("WARNING - object already exists");
    case SC_NOFUNC   :  return("WARNING - function not supported");
    case SC_NOTBFRD  :  return("WARNING - file I/O not buffered");
    case SC_MEMWRN   :  return("WARNING - partial memory allocation");
    case SC_FILENGTH :  return("WARNING - file length is incorrect");
    case SC_FLDROUND :  return("WARNING - numeric field rounded");
    case SC_FLDTRUNC :  return("WARNING - data field truncated");
    case SC_NOFIND   :  return("WARNING - could not find key in index file");
    case SC_END      :  return("WARNING - no more keys");
    case SC_EMPTY    :  return("WARNING - file is empty");
    case SC_DELREC   :  return("WARNING - record read is marked deleted");
    case SC_SUCCESS  :  return("No error or warnings");
    case SC_WRTFAIL  :  return("ERROR - file write failure");
    case SC_RDFAIL   :  return("ERROR - file read failure");
    case SC_MEMERR   :  return("ERROR - memory allocation error");
    case SC_SKFAIL   :  return("ERROR - file pointer reposition failed");
    case SC_NOFILE   :  return("ERROR - file not found");
    case SC_FILBAD   :  return("ERROR - file corrupted");
    case SC_BADEXPR  :  return("ERROR - bad user specified key expression");
    case SC_NOHNDL   :  return("ERROR - no handles available");
    case SC_NOPGS    :  return("ERROR - no index pages loaded");
    case SC_BADPG    :  return("ERROR - index page was not loaded");
    case SC_CLOSFAIL :  return("ERROR - file close failure");
    case SC_BADCMD   :  return("ERROR - invalid command");
    case SC_BADHNDL  :  return("ERROR - invalid handle number");
    case SC_BADFNAME :  return("ERROR - invalid filename");
    case SC_BADDATE  :  return("ERROR - invalid date");
    case SC_BADTIME  :  return("ERROR - invalid time");
    case SC_NODBT    :  return("ERROR - file not in .DBT format");
    case SC_DBFVERS  :  return("ERROR - invalid dBaseIII version");
    case SC_DBFHLEN  :  return("ERROR - file header length error");
    case SC_DBFDATE  :  return("ERROR - last file change date in error");
    case SC_NULLPARM :  return("ERROR - parameter address NULL");
    case SC_BADKEYT  :  return("ERROR - invalid key type");
    case SC_KEYLEN   :  return("ERROR - invalid key length");
    case SC_ITEMLEN  :  return("ERROR - item length incorrect");
    case SC_BADROOT  :  return("ERROR - invalid root page");
    case SC_MAXKEYS  :  return("ERROR - bad maximum number of keys per page");
    case SC_FLDCNT   :  return("ERROR - invalid number of fields");
    case SC_BADFLDN  :  return("ERROR - field name invalid");
    case SC_FLDLEN   :  return("ERROR - bad field length");
    case SC_DECPL    :  return("ERROR - decimal places parameter invalid");
    case SC_BADFLDT  :  return("ERROR - invalid field type");
    case SC_RECLEN   :  return("ERROR - invalid record length");
    case SC_BADDATA  :  return("ERROR - bad data");
    case SC_LINELEN  :  return("ERROR - memo soft line length invalid");
    case SC_MDXFLAG  :  return("ERROR - MDX flag in DBF file invalid");
    case SC_READOLY  :  return("ERROR - file open for reading only");
    case SC_LCKVIOL  :  return("ERROR - file locking violation");
    case SC_LCKBOVR  :  return("ERROR - sharing buffer overflow");
    case SC_NOPATH   :  return("ERROR - path not found");
    case SC_ACCDEN   :  return("ERROR - access to file denied");
    case SC_BADACC   :  return("ERROR - invalid access code");
    case SC_NOTLCKD  :  return("ERROR - file must be locked first");
    case SC_NEWDEV   :  return("ERROR - diskette changed");
    case SC_MINKEYS  :  return("ERROR - bad minimum number of keys per page");
    case SC_FILSOPEN :  return("ERROR - some files remain open");
    case SC_OPENFAIL :  return("ERROR - could not open the file");
    case SC_FLSHFAIL :  return("ERROR - flush to disk failure");
    case SC_BADTAG   :  return("ERROR - invalid tag handle");
    case SC_BLKSZ    :  return("ERROR - invalid page size in blocks");
    case SC_BADTNAME :  return("ERROR - invalid tag name");
    case SC_BLKADR   :  return("ERROR - invalid page offset adder");
    case SC_MAXTAGS  :  return("ERROR - invalid maximum number of tag table elements");
    case SC_TBLELEN  :  return("ERROR - bad tag table element length");
    case SC_TAGCNT   :  return("ERROR - invalid tag count");
    case SC_KEYFORM  :  return("ERROR - unknown key format switches");
    case SC_UNSWITCH :  return("ERROR - unknown switch error");
    case SC_TAGOPEN  :  return("ERROR - tag in use");
    case SC_MLCKERR  :  return("ERROR - Windows GlobalLock error");
    default: return("Unknown error or warning code");

#endif
