#include <string.h>
#include <time.h>
#include <stdio.h>
#include <errno.h>
#include "OpSySInD.h"
#include "dbf.h"

/*********************
 ** >FILE: CreateNdx.c
 *********************/

/********************************************************************
 ** Function:  int CreateNdx(int dbf, char *fname, va_list, int *ndx)
 **
 **    int dbf      database structure
 **    char *fn     file name of the index file to create
 **    va_alist     variable list of key fields to index
 **
 ** Description:
 **    Call this procedure with the full pathname of the index file that you
 ** want to create (fn), the number of fields in a record (n), and a pointer
 ** to an array of FieldRecord_t (flds).  The procedure will initialize all
 ** the data structures in the dbfRecord (D).
 **
 ** Return Values:
 **
 **********************************/

#define INDEX_INC 50

static ByTe_1 rcsid[] = "$Id: CreateNdx.c,v 1.1 1999/11/13 17:45:28 chris.gurgiolo.b2r Stab chrisg $";

int CreateNdx(int dbf, ByTe_1 *fn, ByTe_1 **FieldNames, int NumFields,
              int *ndx)
{
   dbfRecord_t *D;
   ndxRecord_t *N;
   ByTe_1 *cptr, iHeader[96];
   int  i, j, k, nbytes, rval, size;
   FieldRecord_t *field;


   if ((D = GetOldDbfHandle(dbf)) == NULL)
      return FAILURE;
   
  if ((N = GetNewNdxHandle(dbf, ndx)) == NULL)
      return FAILURE;

   /*
    | initialize the header information
    */
   memset(iHeader, 0, sizeof(iHeader));

   /*
    | store the number of fields in the key into the database structure,
    | and allocate memory for the indexed fields
    */
   N->NumIndexFields = NumFields;
   if ((N->IndexFields = (FieldRecord_t *)calloc(NumFields, sizeof(FieldRecord_t))) == NULL)
   {
      dbf_code = errno;
      dbf_msg_clr;
      return FAILURE;
   }

   /*
    | set the number of index fields in the header info
    */
   *((int *)&iHeader[12]) = N->NumIndexFields;

   /*
    | set the index fields
    */
   cptr = &iHeader[16];
   N->KeyLen = 0;
   nbytes = 0;
   for (i=0; i<NumFields; i++)
   {
      if ((field = dbField(dbf, FieldNames[i])) == NULL)
      {
         return FAILURE;
      }
      N->IndexFields[i] = *field;
      *((FieldRecord_t *)cptr) = *(N->IndexFields+i);
      *(cptr+15) = '\0';
      cptr += 16;

      N->KeyLen += N->IndexFields[i].Len;
   }

   /*
    | allocate the needed memory for the index
    */
   nbytes += N->KeyLen + ALIGN(N->KeyLen) + sizeof(int);

   N->MAXIndexRecs = ((D->NumRecs / INDEX_INC) * INDEX_INC) + INDEX_INC;
   
   if ((N->Index = calloc(N->MAXIndexRecs, nbytes)) == NULL)
   {
      dbf_code = errno;
      dbf_msg_clr;
      return FAILURE;
   }

   /*
    | read the records from the database file to generate the index file
    */
   cptr = N->Index;
   N->NextFreeIndexRec = 0;
   for (i=1; i<=D->NumRecs; i++)
   {
      if ((rval = GetDbfRecord(dbf, i)) != SUCCESS)
      {
         return rval;
      }

		if (D->CurRecord[0][0] == '*')
			continue;

      for (k=0; k<N->NumIndexFields; k++)
      {
         for (j=0; j<N->IndexFields[k].Len; j++)
         {
            ByTe_1 c;

            c = (ByTe_1 )N->IndexFields[k].Parm[j];
/****
            if (N->IndexFields[k].Typ == NUMERIC && c == ' ')
               c = '0';
***/
            *(cptr++) = c;
         }

      }

      cptr += ALIGN(N->KeyLen);
      *((int *)cptr) = i;
      cptr += sizeof(int);

      N->NextFreeIndexRec++;
   }

   /*
    | preform the index
    */
   size = N->KeyLen + ALIGN(N->KeyLen) + sizeof(int); 
   db_Qsort(N->Index, D->NumRecs, size, N->KeyLen);

   *((int *)&iHeader[4]) = N->NextFreeIndexRec;
   *((int *)&iHeader[8]) = N->MAXIndexRecs;

   /*
    | open the index file and write out the header and index array
    */
   (void)strcpy((ByTe_1 *)N->IndexName, fn);

   N->iStatus = Updated;

   N->IndexRec = 1;
   GoTo(dbf, ItoR(N, 1));

   return SUCCESS;
}
