#include <stdio.h>
#include <string.h>
#include "OpSySInD.h"
#include <time.h>
#include <errno.h>
#include "dbf.h"

/********************
 ** >FILE: CloseNdx.c
 ********************/

/********************************************
 ** Function:  int CloseNdx(int dbf, int ndx)
 **
 ** Description:
 **    This subroutine closes the index file associated with the database
 ** structure d.  If the current record has been updated then it is written
 ** to the database file.  Once the database file is closed, all the
 ** parameters in the database structure is reset.
 **
 ** Return Values:
 **
 **********************************/

static ByTe_1 rcsid[] = "$Id: CloseNdx.c,v 1.1 1999/11/13 17:45:28 chris.gurgiolo.b2r Stab chrisg $";

int CloseNdx(int dbf, int ndx)
{
   struct tm *mytm;
   time_t Sec;
   dbfRecord_t *D;
   ndxRecord_t *N;
   char *cptr, iHeader[96];
   int fd, i, nbytes;

   if ((D = GetOldDbfHandle(dbf)) == NULL)
      return FAILURE;

   if ((N = GetOldNdxHandle(dbf, ndx)) == NULL)
      return FAILURE;

   if (N->Index == NULL)
      return SUCCESS;

   /*
    | if the header information for the index file has changes re-write it to
    | the index file
    */
   if (N->iStatus == Updated)
   {
      /*
       | first, let's clear a buffer out that will hold this information
       */
      memset(iHeader, 0, sizeof(iHeader));

      /*
       | fill the buffer with the next free record, the maximum number of index
       | records the current index array will hold, and the number of index 
       | fields for the current index array
       */
      *((int *)&iHeader[4])  = N->NextFreeIndexRec;
      *((int *)&iHeader[8])  = N->MAXIndexRecs;
      *((int *)&iHeader[12]) = N->NumIndexFields;

      /*
       | now fill the buffer with all the key field info
       */
      cptr = &iHeader[16];
      N->KeyLen = 0;
      for (i=0; i<N->NumIndexFields; i++)
      {
         memcpy(cptr, (N->IndexFields+i)->Name, FIELD_NAME_LEN);
         memcpy(cptr+FIELD_NAME_LEN, (char *)&(N->IndexFields+i)->Typ, 3);
         *(cptr+15) = '\0';
         cptr += 16;
 
         N->KeyLen += N->IndexFields[i].Len;
      }

      /*
       | open the index file
       */


      if ((fd = open(N->IndexName, O_RDWR)) < 0)
      {
#if defined _MaCiNtOsH && !defined __MWERKS__
         if ((fd = creat(N->IndexName)) < 0)
#else 
         if ((fd = creat(N->IndexName, 0666)) < 0)
#endif
         {
            dbf_code = errno;
            sprintf(msg, "'%s'", N->IndexName);
            return FAILURE;
         }
      }
      lseek (fd, 0L, SEEK_SET);

#ifdef _CyGnUsC
   setmode (fd, O_BINARY);
#endif
#ifdef WIN32
      _setmode (fd, O_BINARY);
#endif


      /*
       | get the date of the file for the header information
       */

      Sec = time ((time_t *)0);
      mytm = localtime(&Sec);

      iHeader[1] = mytm->tm_year; /* Year           */
      iHeader[2] = mytm->tm_mon;  /* Month of year  */
      iHeader[3] = mytm->tm_mday; /* Day of month   */

      /*
       | write out the header information
       */
      if (write(fd, (char *)iHeader, sizeof(iHeader)) < sizeof(iHeader))
      {
         dbf_code = errno;
         sprintf(msg, "'%s'", N->IndexName);
         return FAILURE;
      }

      /*
       | now determine the size of the index array and write it out
       */
      nbytes = N->KeyLen + ALIGN(N->KeyLen) + sizeof(int); 
      nbytes *= N->MAXIndexRecs;

      if (write(fd, (char *)N->Index, nbytes) < nbytes)
      {
         dbf_code = errno;
         sprintf(msg, "'%s'", N->IndexName);
         return FAILURE;
      }

      /*
       | close the index file
       */
      (void)close(fd);

   }

   free((char *)N->IndexFields);
   free(N->Index);

   if (N == D->ndxRecords)
      D->ndxRecords = N->next;

   else
   {
      ndxRecord_t *n;

      for (n = D->ndxRecords ; n->next != NULL; n = n->next)
         if (n->next == N)
            break;

      n->next = N->next;
   }
   free(N);

   return SUCCESS;
}
