#include <stdio.h>
#include <time.h>
#include "OpSySInD.h"
#include "dbf.h"

/********************
 ** >FILE: CloseDbf.c
 ********************/

/**************************************
 ** Function:  int CloseDbf(int handle)
 **
 **    int handle    database handle
 **
 ** Description:
 **    This subroutine closes the database file associated with the database
 ** structure D.  If the current record has been updated then it is written
 ** to the database file.  Once the database file is closed, all the
 ** parameters in the database structure is reset, and any pointers are
 ** freed.
 **
 ** Return Values:
 **    * FAILURE - dbf_code set to actual error
 **    * SUCCESS - the routine completed without error
 **
 **********************************/

static ByTe_1 rcsid[] = "$Id: CloseDbf.c,v 1.1 1999/11/13 17:45:28 chris.gurgiolo.b2r Stab chrisg $";

int CloseDbf(int handle)
{
   dbfRecord_t *D;

   if ((D = GetOldDbfHandle(handle)) == NULL)
      return FAILURE;

   /*
    | update the database file if needed
    */ 
   if (D->rStatus == Updated)
   {
      if (PutDbfRecord(handle, D->CurRec) != SUCCESS)
      {
         return FAILURE;
      }
   }
   if (D->hStatus == Updated)
   {
      if (UpdateHeader(D) != SUCCESS)
      {
         return FAILURE;
      }
   }

   /*
    | close the database file and set the appropiate variables
    */
   (void)close(D->dFile);
   D->dFile   = -1;
   D->hStatus = NotOpen;

   /*
    | free any memory associated with the database structure
    */
   free((ByTe_1 *)D->CurRecord);
   D->CurRecord = NULL;

   free((ByTe_1 *)D->Fields);
   D->Fields = NULL;

   if (D == dbfRecords)
      dbfRecords = D->next;

   else
   {
      dbfRecord_t *d;

      for (d = dbfRecords ; d->next != NULL; d = d->next)
         if (d->next == D)
            break;

      d->next = D->next;
   }
   free(D);

   return SUCCESS;
}
