#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "Gmenu_defs.h"
#include "Gmenu_str.h"
#include "Gmenu_ansi.h"

static ByTe_1 rcsid[] = "$Id: ReadQues.c,v 1.1 1999/11/21 10:43:44 chris.gurgiolo.b2r Stab chrisg $";

ByTe_4 ReadQues (ByTe_4 PN, ByTe_4 QN)
{
  extern struct MeNuS Ms;
  struct PaGe *Pg;
  struct QuEsTiOnS *Qs;

  ByTe_4  ok;
  ByTe_1  line[160];

  ByTe_1  *c1, E[256], id[40];

  ByTe_1  *err1  = "BAD PAGE NUMBER";

  if (PN < 0)                                      /* illegal page number   */
     ErrMsg ("READQUES: ", err1, -1);              /* report and leave      */

  Pg = (struct PaGe *) Ms.page + PN;               /* pt to page info       */
  Qs = (struct QuEsTiOnS *)Pg->Ques + QN;          /* ptr to ques info      */
  Qs->Pnum = PN;                                   /* set page number       */
  Qs->Qnum = QN;                                   /* set question number   */

  InitQues (Qs);                                   /* initialize structure  */

  while (RdLine(Ms.fd, line) > 0)                  /* read next line        */
  {
    c1 = line;                                     /* ptr to entry line     */
    c1 = Lentry (c1, id);                          /* ID entry              */
    c1 = Lentry (c1, E);                           /* get next entry now    */
    switch (id[0])                                 /* jump to possible ID   */
    {
       case 'A':                                   /* C_REPLY               */
          if (CHK("ALTVAL") == 0)                  /* C_REPLY DEFINED?      */
             RmSpaces (E, Qs->AltVal);             /* yes! strip it out     */
       break;

       case 'C':                                   /* C_REPLY               */
          if (CHK("CREPLY") == 0)                  /* C_REPLY DEFINED?      */
             RmSpaces (E, Qs->CReply);             /* yes! strip it out     */
       break;

       case 'I':                                   /* QUESTION ID           */
          if (CHK("ID") == 0)                      /* ID DEFINED?           */
             sscanf (E, "%d", &Qs->ID);            /* Get it!               */
       break;
 
       case 'F':                                   /* FORMAT                */
          if (CHK("FMT") == 0)                     /* FORMAT DEFINED?       */
             RmSpaces (E, Qs->Fmt);                /* yes! strip it out     */
       break;

       case 'N':                                   /* Num of Wins           */
          if (CHK("NWINS") == 0)                   /* NWINS DEFINED?        */
             sscanf (E, "%d", &Qs->NWins);         /* Get it!               */
       break;
  
       case 'O':                                   /* OpReply               */
          if (CHK("OPREPLY") == 0)                 /* REPLYOP DEFINED?      */
             sscanf (E, "%d", &Qs->OpReply);       /* option position      */
       break;
 
       case 'R':                                   /* REPLYS                */
          if (CHK("RNUM") == 0)                    /* RNUM DEFINED?         */
            sscanf (E, "%d", &Qs->NumR);           /* number of replys      */
       break;

       case 'S':                                    /* QUALITY               */
          if (CHK("STATE") == 0)                    /* valid entry?          */
             sscanf (E, "%d", &Qs->state);          /* number of replys      */
       break;

       case 'W':                                    /* DEFINES PAGES         */
          if (CHK("WINS") == 0)                     /* WINS DEFINED?         */
             RmSpaces (E, Qs->Wins);                /* yes! strip it out     */
       break;

       case '|':                                    /* end entry for PAGE    */
          return (1);
    }
  }
  return (0);
}
