#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "OpSySInD.h"
#include "libCfg.h"
#include "Pconfig.h"

static ByTe_1 rcsid[] = "$Id: parse_config.c,v 1.1 1999/11/12 19:57:31 chris.gurgiolo.b2r Stab chrisg $";

int parse_config(config_t *handle, ByTe_1 *prefix, def_t *deflist)
{
   ByTe_1     symbol[SYMBOLSIZE], *token;
   int      deflist_len, i, prefix_len, ret=0, undef=0;

/*
   Determine the length of the definition list.  Look for the first list
   element with a NULL value in the param field.
*/
   for (deflist_len = 0; deflist[deflist_len].param != NULL; deflist_len++);

/*
   Find the length of the prefix string.  If the value of prefix is NULL,
   set the length to 0.
*/
   prefix_len = (prefix) ? strlen(prefix) : 0;

/*
   Search the definition list for a param entry that matches symbol.
*/
   for (i = 0; i < deflist_len; i++)
   {
/*
   If the required field of the current entry is negative, then this
   entry has already been processed in a previous line of the
   configuration file.  Go to the next definition list entry.
*/
      if (deflist[i].required < 0)
      {
         continue;
      }

/*
   Initialize a blank symbol, concatenate the prefix, if any, then add the
   param to search for.
*/
      memset(symbol, 0, SYMBOLSIZE);

      if (prefix_len)
      {
         strcat(symbol, prefix);
      }

      strcat(symbol, deflist[i].param);

/*
   Look for the symbol in the symbol table, if the symbol cannot be found
   send a message to stderr and set ret to -1.
*/
      if ((token = get_symbol(handle, symbol)) == NULL)
      {
         if (deflist[i].required == IS_REQUIRED)
         {
            if (!undef)
            {
               fprintf(stderr, "parse_config: undefined symbol(s)\n");
               undef = 1;
            }
            fprintf(stderr, "\t%s\n", symbol);
            ret = -1;
         }
         continue;
      }

/*
   Found the symbol in question, process the symbol and assign its value
   to the value field of the def list.
*/
      process_symbol(&deflist[i], token);
   }

/*
   Return ret to indicate the success or failure of the routine.
*/
   return ret;
}
