#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "OpSySInD.h"
#include "libCfg.h"
#include "Pconfig.h"

static ByTe_1 rcsid[] = "$Id: open_config.c,v 1.1 1999/11/12 19:57:31 chris.gurgiolo.b2r Stab chrisg $";

config_t * open_config(ByTe_1 *file)
{
   FILE     *fp;
   config_t *ch;

   ByTe_1 *buffer = 0;
   ByTe_1 *param, *value;
   int  bufsize = 0;
   int  tokens;

/* 1.  Get the stream file pointer.  If error, ch is set to NULL.            */
/* 2.  Create the config symbol table.  If error, ch is set to NULL.         */
/* 3.  Load the config symbol table.  If error, ch is set to NULL.           */
/* 3a. Get parameter/value token pairs from the input stream.  Get_tokens    */
/*     returns a -1 when no more tokens are available.                       */
/* 3b. If both a parameter and a value were matched, add the symbol pair to  */
/*     the symbol table.  If there is an error adding the symbol, destroy    */
/*     the config structures and return a NULL.                              */
/* 4.  If the input was not stdin and not NULL, close the input stream.      */

   if (file[0] == '\0' || file[0] == '-')                             /*  1  */
      fp = stdin;
   else
   {
      if ((fp = fopen(file, "r")) == NULL)
      {
         perror("open_config.fopen");
         ch = CNULL;
      }
   }

   if (fp != NULL)                                                    /*  2  */
   {
      if ((ch = (config_t *)calloc(1, sizeof(config_t))) == CNULL)
         perror("open_config..calloc");
      else                                                            /*  3  */
      {
         while ((tokens = pc_get_tokens(fp, &param, &value, 
                                          &buffer, &bufsize)) != -1)  /*  3a */
         {
             if (tokens == 2)                                         /*  3b */
             {
                if (pc_add_symbol(ch, param, value) != 0)
                {
                   ch = pc_destroy_config(ch);
                   break;
                }
             }
          }
      }
   }

   if (fp != stdin && fp != NULL)                                     /*  4  */
   {
      fclose(fp);
      if (buffer != 0)
         free(buffer);
      buffer = 0;
      bufsize = 0;
   }

   return ch;
}
