#include <stdarg.h>
#include <string.h>
#include "LinkList.h"
#include "StrHier.h"
#include "libCfg.h"

#define MAXARGS 10

/*
 * LinkList List - root to tree to start query
 *
 * This routine returns a node defined by its string.  Routine may take a
 * varing number of args to query a specific node.  Last argument must be 0.
 */

static ByTe_1 rcsid[] = "$Id: SourceByStr.c,v 1.1 1999/11/12 19:57:31 chris.gurgiolo.b2r Stab chrisg $";

StrHier SourceByStr(LinkList List, ...)
{
   va_list ap;
   ByTe_1 *str, **arg, *args[MAXARGS];
   int argno = 0;

   LinkList L;
   static StrHier S;


   va_start (ap, List);

   str = va_arg(ap, ByTe_1 *);

   while ((args[argno++] = va_arg(ap, ByTe_1 *)) != (ByTe_1 *)0);

   va_end (ap);

   for (L=List; L != NULL; L=L->next)
   {
      S = (StrHier)L->data;

      if (strcmp(SNAME(S), str) == 0)
      {
         for (arg=args; *arg != 0; arg++)
         {
            if ((S = SourceByStr(SUBLIST(S), *arg, 0)) == NULL)
            {
               return (StrHier) NULL;
            }
         }
         return S;
      }
   }

   return (StrHier) NULL;
}
